/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.tokenizer;

import java.util.ArrayList;
import java.util.List;
import manifold.templates.tokenizer.Token;

public class Tokenizer {
    private int _index;
    private List<Token> _tokens;
    private CharSequence _text;
    private StringBuilder _stuff;
    private int _tokenIndex;
    private int _stuffLine;
    private int _stuffColumn;
    private boolean _isParsingString;
    private boolean _isParsingCharLiteral;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> tokenize(CharSequence text) {
        this._tokens = new ArrayList<Token>();
        this._tokenIndex = -1;
        this._index = 0;
        this._text = text;
        this._isParsingString = false;
        this._isParsingCharLiteral = false;
        this._stuff = new StringBuilder();
        int line = 1;
        int column = 1;
        int index = this._index;
        boolean escaped = false;
        this.nextToken();
        while (index < this._text.length()) {
            int before = index;
            char c = this._text.charAt(index);
            if (c == '\n') {
                ++line;
                column = 1;
            }
            if (!escaped && c == '\\' && !this.isInCode() && this._text.length() > index + 1 && (this.charIs(index + 1, '<') || this.charIs(index + 1, '$'))) {
                escaped = true;
                ++index;
                continue;
            }
            if (this.isTop(Token.TokenType.COMMENT_BEGIN)) {
                if (c == '-' && this.charIs(++index, '-') && this.charIs(++index, '%') && this.charIs(++index, '>')) {
                    this.pushStuff();
                    this.pushToken(Token.TokenType.COMMENT_END, ++index, line, column);
                    continue;
                }
            } else if (c == '$' && !this.isInCode() && !escaped) {
                if (this.charIs(++index, '{')) {
                    this.pushStuff();
                    this.pushToken(Token.TokenType.EXPR_BRACE_BEGIN, ++index, line, column);
                    continue;
                }
            } else if (c == '<' && !this.isInCode() && !escaped) {
                if (this.charIs(++index, '%')) {
                    this.pushStuff();
                    if (this.charIs(++index, '=')) {
                        this.pushToken(Token.TokenType.EXPR_ANGLE_BEGIN, ++index, line, column);
                        continue;
                    }
                    if (this.charIs(index, '@')) {
                        this.pushToken(Token.TokenType.DIR_ANGLE_BEGIN, ++index, line, column);
                        continue;
                    }
                    if (this.charIs(index, '-') && this.charIs(index + 1, '-')) {
                        this.pushToken(Token.TokenType.COMMENT_BEGIN, index += 2, line, column);
                        continue;
                    }
                    this.pushToken(Token.TokenType.STMT_ANGLE_BEGIN, index, line, column);
                    continue;
                }
            } else {
                if (c == '}' && this.isTop(Token.TokenType.EXPR_BRACE_BEGIN) && this.isInCode() && !this.isParsingString() && !this.isParsingCharLiteral()) {
                    this.pushStuff();
                    this.pushToken(Token.TokenType.EXPR_BRACE_END, ++index, line, column);
                    continue;
                }
                if (c == '%' && this.isInCode() && !this.isParsingString() && this.charIs(++index, '>')) {
                    this.pushStuff();
                    this.pushToken(Token.TokenType.ANGLE_END, ++index, line, column);
                    continue;
                }
            }
            if (this._stuff.length() == 0) {
                this._stuffLine = line;
                this._stuffColumn = column;
            }
            this._stuff.append(c);
            index = before + 1;
            this.setParsingString(c, before);
            this.setParsingCharLiteral(c, before);
            escaped = false;
        }
        this.pushStuff();
        try {
            List<Token> list = this._tokens;
            return list;
        }
        finally {
            this.clear();
        }
    }

    private void nextToken() {
        this._tokenIndex = this._tokenIndex + 1 < this._tokens.size() ? ++this._tokenIndex : -1;
    }

    private boolean charIs(int index, char c) {
        return this._text.length() > index && this._text.charAt(index) == c;
    }

    private void pushStuff() {
        Token.TokenType beginType;
        if (this._stuff == null || this._stuff.length() == 0) {
            return;
        }
        Token.TokenType tokenType = beginType = this._tokens.size() == 0 ? null : this.peek().getType();
        Token.TokenType stuffType = beginType == Token.TokenType.EXPR_BRACE_BEGIN || beginType == Token.TokenType.EXPR_ANGLE_BEGIN ? Token.TokenType.EXPR : (beginType == Token.TokenType.STMT_ANGLE_BEGIN ? Token.TokenType.STMT : (beginType == Token.TokenType.DIR_ANGLE_BEGIN ? Token.TokenType.DIRECTIVE : (beginType == Token.TokenType.COMMENT_BEGIN ? Token.TokenType.COMMENT : Token.TokenType.CONTENT)));
        this._tokens.add(new Token(stuffType, this._index, this._stuff.toString(), this._stuffLine, this._stuffColumn));
        this._index += this._stuff.length();
        this._stuff = new StringBuilder();
    }

    private void pushToken(Token.TokenType tokenType, int index, int line, int column) {
        String token = tokenType.getToken();
        if (token == null) {
            throw new IllegalStateException("Expected static token, but found: " + tokenType.name());
        }
        this._tokens.add(new Token(tokenType, this._index, token, line, column));
        this._index = index;
    }

    private boolean isInCode() {
        return this.isTop(Token.TokenType.EXPR_ANGLE_BEGIN) || this.isTop(Token.TokenType.EXPR_BRACE_BEGIN) || this.isTop(Token.TokenType.STMT_ANGLE_BEGIN) || this.isTop(Token.TokenType.DIR_ANGLE_BEGIN) || this.isTop(Token.TokenType.COMMENT_BEGIN);
    }

    private boolean isTop(Token.TokenType tokenType) {
        return !this._tokens.isEmpty() && this.peek().getType() == tokenType;
    }

    private void setParsingString(char c, int index) {
        if (!this.isInCode() || c != '\"') {
            return;
        }
        if (!this.isParsingString()) {
            this._isParsingString = true;
        } else if (!this.charIs(index - 1, '\\')) {
            this._isParsingString = false;
        }
    }

    private boolean isParsingString() {
        return this._isParsingString;
    }

    private void setParsingCharLiteral(char c, int index) {
        if (!this.isInCode() || c != '\'' || this.isParsingString()) {
            return;
        }
        if (!this.isParsingCharLiteral()) {
            this._isParsingCharLiteral = true;
        } else if (!this.charIs(index - 1, '\\')) {
            this._isParsingCharLiteral = false;
        }
    }

    private boolean isParsingCharLiteral() {
        return this._isParsingCharLiteral;
    }

    private Token peek() {
        return this._tokens.get(this._tokens.size() - 1);
    }

    private void clear() {
        this._text = null;
        this._tokens = null;
        this._stuff = null;
        this._index = -1;
    }
}

