/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.yaml.rt.parser;

import java.util.List;
import java.util.Map;
import manifold.ext.rt.ReflectionRuntimeMethods;
import manifold.ext.rt.extensions.java.lang.Object.ManObjectExt;
import manifold.json.rt.api.DataBindings;
import manifold.json.rt.parser.Token;
import manifold.json.rt.parser.TokenType;
import manifold.rt.api.util.Pair;
import manifold.util.ReflectUtil;
import org.snakeyaml.engine.v1.api.Load;
import org.snakeyaml.engine.v1.api.LoadSettings;
import org.snakeyaml.engine.v1.api.LoadSettingsBuilder;
import org.snakeyaml.engine.v1.constructor.BaseConstructor;
import org.snakeyaml.engine.v1.constructor.StandardConstructor;
import org.snakeyaml.engine.v1.exceptions.ConstructorException;
import org.snakeyaml.engine.v1.exceptions.Mark;
import org.snakeyaml.engine.v1.nodes.MappingNode;
import org.snakeyaml.engine.v1.nodes.Node;
import org.snakeyaml.engine.v1.nodes.NodeTuple;

public class YamlParser {
    public static Object parseYaml(String yaml, boolean withTokens) {
        LoadSettings loadSettings = new LoadSettingsBuilder().setUseMarks(true).setDefaultMap(DataBindings::new).build();
        Load load = new Load(loadSettings, (BaseConstructor)new MyConstructor(loadSettings, withTokens));
        return load.loadFromString(yaml);
    }

    private static class MyConstructor
    extends StandardConstructor {
        private final boolean _withTokens;

        MyConstructor(LoadSettings settings, boolean withTokens) {
            super(settings);
            this._withTokens = withTokens;
        }

        protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
            if (!this._withTokens) {
                super.constructMapping2ndStep(node, mapping);
                return;
            }
            this.flattenMapping(node);
            List nodeValue = node.getValue();
            for (NodeTuple tuple : nodeValue) {
                Node keyNode = tuple.getKeyNode();
                Node valueNode = tuple.getValueNode();
                Object key = this.constructObject(keyNode);
                if (key != null) {
                    try {
                        key.hashCode();
                    }
                    catch (Exception e) {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), (Throwable)e);
                    }
                }
                Object value = this.constructObject(valueNode);
                value = this.makeTokensValue(keyNode, valueNode, value);
                if (keyNode.isRecursive()) {
                    String inner = "RecursiveTuple";
                    inner = '$' + inner;
                    ReflectUtil.ConstructorRef constructor = ReflectUtil.constructor((String)(BaseConstructor.class.getTypeName() + inner), (Class[])new Class[]{Object.class, Object.class});
                    Object recursiveTuple = constructor.newInstance(new Object[]{key, value});
                    Object element = constructor.newInstance(new Object[]{mapping, recursiveTuple});
                    List maps2fill = (List)ReflectionRuntimeMethods.getField_Object((Object)ManObjectExt.jailbreak((Object)((Object)this)), (String)"maps2fill");
                    maps2fill.add(0, element);
                    continue;
                }
                mapping.put(key, value);
            }
        }

        private Object makeTokensValue(Node keyNode, Node valueNode, Object value) {
            Token valueToken;
            Token keyToken = this.makeToken(keyNode);
            if (keyToken != null && (valueToken = this.makeToken(valueNode)) != null) {
                value = new Pair((Object)new Token[]{keyToken, valueToken}, value);
            }
            return value;
        }

        private Token makeToken(Node node) {
            if (node.getStartMark().isPresent()) {
                Mark mark = (Mark)node.getStartMark().get();
                return new Token(TokenType.STRING, node.getTag().getValue(), mark.getIndex(), mark.getLine(), mark.getColumn());
            }
            return null;
        }
    }
}

