/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import tech.allegro.schema.json2avro.converter.JsonToAvroReader;
import tech.allegro.schema.json2avro.converter.UnknownFieldListener;
import tech.allegro.schema.json2avro.converter.types.ArrayConverter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;
import tech.allegro.schema.json2avro.converter.types.BytesDecimalConverter;
import tech.allegro.schema.json2avro.converter.types.EnumConverter;
import tech.allegro.schema.json2avro.converter.types.IntDateConverter;
import tech.allegro.schema.json2avro.converter.types.IntTimeMillisConverter;
import tech.allegro.schema.json2avro.converter.types.LongTimeMicrosConverter;
import tech.allegro.schema.json2avro.converter.types.LongTimestampMicrosConverter;
import tech.allegro.schema.json2avro.converter.types.LongTimestampMillisConverter;
import tech.allegro.schema.json2avro.converter.types.MapConverter;
import tech.allegro.schema.json2avro.converter.types.NullConverter;
import tech.allegro.schema.json2avro.converter.types.PrimitiveConverter;
import tech.allegro.schema.json2avro.converter.types.RecordConverter;
import tech.allegro.schema.json2avro.converter.types.UnionConverter;

public class CompositeJsonToAvroReader
implements JsonToAvroReader {
    private final List<AvroTypeConverter> converters;
    private final AvroTypeConverter mainRecordConverter;

    public CompositeJsonToAvroReader() {
        this(Collections.emptyList(), null);
    }

    public CompositeJsonToAvroReader(List<AvroTypeConverter> additionalConverters) {
        this(additionalConverters, null);
    }

    public CompositeJsonToAvroReader(AvroTypeConverter ... additionalConverters) {
        this(Arrays.asList(additionalConverters));
    }

    public CompositeJsonToAvroReader(List<AvroTypeConverter> additionalConverters, UnknownFieldListener unknownFieldListener) {
        this.mainRecordConverter = this.createMainConverter(unknownFieldListener);
        this.converters = new ArrayList<AvroTypeConverter>();
        this.converters.addAll(additionalConverters);
        this.converters.add(BytesDecimalConverter.INSTANCE);
        this.converters.add(IntDateConverter.INSTANCE);
        this.converters.add(IntTimeMillisConverter.INSTANCE);
        this.converters.add(LongTimeMicrosConverter.INSTANCE);
        this.converters.add(LongTimestampMillisConverter.INSTANCE);
        this.converters.add(LongTimestampMicrosConverter.INSTANCE);
        this.converters.add(PrimitiveConverter.BOOLEAN);
        this.converters.add(PrimitiveConverter.STRING);
        this.converters.add(PrimitiveConverter.INT);
        this.converters.add(PrimitiveConverter.LONG);
        this.converters.add(PrimitiveConverter.DOUBLE);
        this.converters.add(PrimitiveConverter.FLOAT);
        this.converters.add(PrimitiveConverter.BYTES);
        this.converters.add(EnumConverter.INSTANCE);
        this.converters.add(NullConverter.INSTANCE);
        this.converters.add(this.mainRecordConverter);
        this.converters.add(new ArrayConverter(this));
        this.converters.add(new MapConverter(this));
        this.converters.add(new UnionConverter(this));
    }

    protected AvroTypeConverter createMainConverter(UnknownFieldListener unknownFieldListener) {
        return new RecordConverter(this, unknownFieldListener);
    }

    @Override
    public GenericData.Record read(Map<String, Object> json, Schema schema) {
        return (GenericData.Record)this.mainRecordConverter.convert(null, schema, json, new ArrayDeque<String>(), false);
    }

    @Override
    public Object read(Schema.Field field, Schema schema, Object jsonValue, Deque<String> path, boolean silently) {
        boolean pushed;
        boolean bl = pushed = !field.name().equals(path.peekLast());
        if (pushed) {
            path.addLast(field.name());
        }
        AvroTypeConverter converter = this.converters.stream().filter(c -> c.canManage(schema, path)).findFirst().orElseThrow(() -> new AvroTypeException("Unsupported type: " + String.valueOf(field.schema().getType())));
        Object result = converter.convert(field, schema, jsonValue, path, silently);
        if (pushed) {
            path.removeLast();
        }
        return result;
    }
}

