/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public class BytesDecimalConverter
implements AvroTypeConverter {
    public static final AvroTypeConverter INSTANCE = new BytesDecimalConverter();

    @Override
    public Object convert(Schema.Field field, Schema schema, Object value, Deque<String> path, boolean silently) {
        try {
            int scale = (Integer)schema.getObjectProp("scale");
            return this.convertDecimal(value, scale, path);
        }
        catch (NumberFormatException exception) {
            if (silently) {
                return new AvroTypeConverter.Incompatible("string number, decimal");
            }
            throw new AvroTypeException("Field " + PathsPrinter.print(path) + " is expected to be a valid number. current value is " + String.valueOf(value) + ".");
        }
    }

    protected Object convertDecimal(Object value, int scale, Deque<String> path) {
        BigDecimal bigDecimal = this.bigDecimalWithExpectedScale(value.toString(), scale, path);
        return ByteBuffer.wrap(bigDecimal.unscaledValue().toByteArray());
    }

    protected BigDecimal bigDecimalWithExpectedScale(String decimal, int scale, Deque<String> path) {
        BigDecimal bigDecimalInput = new BigDecimal(decimal);
        if (bigDecimalInput.scale() <= scale) {
            return bigDecimalInput.setScale(scale, RoundingMode.UNNECESSARY);
        }
        throw new AvroTypeException("Field " + PathsPrinter.print(path) + " is expected to be a number with scale up to " + scale + ". current value: " + String.valueOf(bigDecimalInput) + " is number with scale " + bigDecimalInput.scale() + ".");
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> deque) {
        return Schema.Type.BYTES.equals((Object)schema.getType()) && AvroTypeConverter.isLogicalType(schema, "decimal") && schema.getObjectProp("scale") != null;
    }
}

