/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SQL;
import tech.jhipster.service.ColumnConverterReactive;
import tech.jhipster.service.filter.BooleanFilter;
import tech.jhipster.service.filter.DurationFilter;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.InstantFilter;
import tech.jhipster.service.filter.RangeFilter;
import tech.jhipster.service.filter.StringFilter;
import tech.jhipster.service.filter.ZonedDateTimeFilter;

public class ConditionBuilder {
    private final List<Condition> allFilters = new ArrayList<Condition>();
    private final ColumnConverterReactive columnConverter;

    public ConditionBuilder(ColumnConverterReactive columnConverter) {
        this.columnConverter = columnConverter;
    }

    public <X> void buildFilterConditionForField(Filter<X> field, Column column) {
        if (field instanceof DurationFilter) {
            this.buildRangeConditions((DurationFilter)field, column, Long.class);
            this.buildGeneralConditions(field, column, Long.class);
        } else if (field instanceof ZonedDateTimeFilter) {
            this.buildRangeConditions((ZonedDateTimeFilter)field, column, LocalDateTime.class);
            this.buildGeneralConditions(field, column, LocalDateTime.class);
        } else if (field instanceof InstantFilter) {
            this.buildRangeConditions((InstantFilter)field, column, LocalDateTime.class);
            this.buildGeneralConditions(field, column, LocalDateTime.class);
        } else if (field instanceof RangeFilter) {
            this.buildRangeConditions((RangeFilter)field, column, null);
            this.buildGeneralConditions(field, column, null);
        } else if (field instanceof StringFilter) {
            this.buildStringConditions((StringFilter)field, column);
            this.buildGeneralConditions(field, column, null);
        } else if (field instanceof BooleanFilter) {
            this.buildBooleanConditions(field, column);
        } else {
            this.buildGeneralConditions(field, column, null);
        }
    }

    public Condition buildConditions() {
        return this.allFilters.stream().reduce(null, (cumulated, eachCondition) -> cumulated != null ? cumulated.and(eachCondition) : eachCondition);
    }

    private <X> Function<X, String> columnValueConverter(Class<?> targetClass) {
        if (targetClass != null) {
            return value -> this.columnConverter.convert(value, targetClass).toString();
        }
        return value -> value.toString();
    }

    private <X extends Comparable<? super X>> void buildRangeConditions(RangeFilter<X> rangeData, Column column, Class<?> targetClass) {
        Function<X, String> converterFunction = this.columnValueConverter(targetClass);
        if (rangeData.getGreaterThan() != null) {
            this.allFilters.add((Condition)Conditions.isGreater((Expression)column, (Expression)SQL.literalOf((CharSequence)converterFunction.apply(rangeData.getGreaterThan()))));
        }
        if (rangeData.getLessThan() != null) {
            this.allFilters.add((Condition)Conditions.isLess((Expression)column, (Expression)SQL.literalOf((CharSequence)converterFunction.apply(rangeData.getLessThan()))));
        }
        if (rangeData.getGreaterThanOrEqual() != null) {
            this.allFilters.add((Condition)Conditions.isGreaterOrEqualTo((Expression)column, (Expression)SQL.literalOf((CharSequence)converterFunction.apply(rangeData.getGreaterThanOrEqual()))));
        }
        if (rangeData.getLessThanOrEqual() != null) {
            this.allFilters.add((Condition)Conditions.isLessOrEqualTo((Expression)column, (Expression)SQL.literalOf((CharSequence)converterFunction.apply(rangeData.getLessThanOrEqual()))));
        }
    }

    private void buildStringConditions(StringFilter stringData, Column column) {
        if (stringData.getContains() != null) {
            this.allFilters.add((Condition)Conditions.like((Expression)column, (Expression)SQL.literalOf((CharSequence)stringData.getContains())));
        }
        if (stringData.getDoesNotContain() != null) {
            this.allFilters.add((Condition)Conditions.notLike((Expression)column, (Expression)SQL.literalOf((CharSequence)stringData.getDoesNotContain())));
        }
    }

    private <X> void buildBooleanConditions(Filter<X> generalData, Column column) {
        if (generalData.getEquals() != null) {
            this.allFilters.add((Condition)Conditions.isEqual((Expression)column, (Expression)SQL.literalOf((Object)this.columnConverter.convert(generalData.getEquals(), Boolean.class))));
        }
        if (generalData.getNotEquals() != null) {
            this.allFilters.add((Condition)Conditions.isNotEqual((Expression)column, (Expression)SQL.literalOf((Object)this.columnConverter.convert(generalData.getNotEquals(), Boolean.class))));
        }
        if (generalData.getIn() != null && generalData.getIn().size() > 0) {
            this.allFilters.add(Conditions.in((Expression)column, (Collection)generalData.getIn().stream().map(eachIn -> SQL.literalOf((Object)this.columnConverter.convert(eachIn, Boolean.class))).collect(Collectors.toList())));
        }
        if (generalData.getNotIn() != null && generalData.getNotIn().size() > 0) {
            this.allFilters.add(Conditions.notIn((Expression)column, (Collection)generalData.getNotIn().stream().map(eachNotIn -> SQL.literalOf((Object)this.columnConverter.convert(eachNotIn, Boolean.class))).collect(Collectors.toList())));
        }
        if (generalData.getSpecified() != null && generalData.getSpecified().booleanValue()) {
            this.allFilters.add(Conditions.isNull((Expression)column).not());
        }
        if (generalData.getSpecified() != null && !generalData.getSpecified().booleanValue()) {
            this.allFilters.add((Condition)Conditions.isNull((Expression)column));
        }
    }

    private <X> void buildGeneralConditions(Filter<X> generalData, Column column, Class<?> targetClass) {
        Function converterFunction = this.columnValueConverter(targetClass);
        if (generalData.getEquals() != null) {
            this.allFilters.add((Condition)Conditions.isEqual((Expression)column, (Expression)SQL.literalOf((CharSequence)converterFunction.apply(generalData.getEquals()))));
        }
        if (generalData.getNotEquals() != null) {
            this.allFilters.add((Condition)Conditions.isNotEqual((Expression)column, (Expression)SQL.literalOf((CharSequence)converterFunction.apply(generalData.getNotEquals()))));
        }
        if (generalData.getIn() != null && generalData.getIn().size() > 0) {
            this.allFilters.add(Conditions.in((Expression)column, (Collection)generalData.getIn().stream().map(eachIn -> SQL.literalOf((CharSequence)((CharSequence)converterFunction.apply(eachIn)))).collect(Collectors.toList())));
        }
        if (generalData.getNotIn() != null && generalData.getNotIn().size() > 0) {
            this.allFilters.add(Conditions.notIn((Expression)column, (Collection)generalData.getNotIn().stream().map(eachNotIn -> SQL.literalOf((CharSequence)((CharSequence)converterFunction.apply(eachNotIn)))).collect(Collectors.toList())));
        }
        if (generalData.getSpecified() != null && generalData.getSpecified().booleanValue()) {
            this.allFilters.add(Conditions.isNull((Expression)column).not());
        }
        if (generalData.getSpecified() != null && !generalData.getSpecified().booleanValue()) {
            this.allFilters.add((Condition)Conditions.isNull((Expression)column));
        }
    }
}

