/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import tech.jhipster.config.JHipsterProperties;

public class CachingHttpHeadersFilter
implements Filter {
    public static final int DEFAULT_DAYS_TO_LIVE = 1461;
    public static final long DEFAULT_SECONDS_TO_LIVE = TimeUnit.DAYS.toSeconds(1461L);
    private long cacheTimeToLive = DEFAULT_SECONDS_TO_LIVE;
    private JHipsterProperties jHipsterProperties;

    public CachingHttpHeadersFilter(JHipsterProperties jHipsterProperties) {
        this.jHipsterProperties = jHipsterProperties;
    }

    public void init(FilterConfig filterConfig) {
        this.cacheTimeToLive = TimeUnit.DAYS.toSeconds(this.jHipsterProperties.getHttp().getCache().getTimeToLiveInDays());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setHeader("Cache-Control", "max-age=" + this.cacheTimeToLive + ", public");
        httpResponse.setHeader("Pragma", "cache");
        httpResponse.setDateHeader("Expires", TimeUnit.SECONDS.toMillis(this.cacheTimeToLive) + System.currentTimeMillis());
        chain.doFilter(request, response);
    }
}

