/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.lang.reflect.AnnotatedElement;

import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;

/**
 * XML validator class.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLValidator extends MetadataValidator  { 
    /**
     * INTERNAL
     */
    public XMLValidator() {}
    
    /**
     * INTERNAL
     */
    public void throwEmbeddedIdAndIdFound(Class entityClass, String attributeName, String idAttributeName) {
        throw ValidationException.embeddedIdAndIdElementFound(entityClass, attributeName, idAttributeName);
    }
    
    /**
     * INTERNAL
     */
    public void throwErrorProcessingNamedQueryElement(String queryName, Exception exception) {
        throw ValidationException.errorProcessingNamedQueryElement(queryName, exception);
    }
    
    /**
     * INTERNAL
     */
    public void throwExcessiveJoinColumnsSpecified(Class entityClass, Object element) {
        throw ValidationException.excessiveJoinColumnElementsSpecified((String) element, entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwExcessivePrimaryKeyJoinColumnsSpecified(Class entityClass, AnnotatedElement annotatedElement) {
        throw ValidationException.excessivePrimaryKeyJoinColumnElementsSpecified(entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwIncompleteJoinColumnsSpecified(Class entityClass, Object element) {
        throw ValidationException.incompleteJoinColumnElementsSpecified(element, entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwIncompletePrimaryKeyJoinColumnsSpecified(Class entityClass, AnnotatedElement annotatedElement) {
        throw ValidationException.incompletePrimaryKeyJoinColumnElementsSpecified(entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwMultipleEmbeddedIdsFound(Class entityClass, String attributeName, String embeddedIdAttributeName) {
        throw ValidationException.multipleEmbeddedIdElementsFound(entityClass, attributeName, embeddedIdAttributeName);
    }
    
    /**
     * INTERNAL
     */
    public void throwNoMappedByAttributeFound(Class owningClass, String owningAttributeName, Class entityClass, String attributeName) {
        // ignore, not applicable.
    }
    
    /**
     * INTERNAL
     */
    public void throwNoTemporalTypeSpecified(Class entityClass, String attributeName) {
        // WIP - copied from AnnotationsValidator ... might need to have its own ...
        throw ValidationException.noTemporalTypeSpecified(attributeName, entityClass);
    }
    
    /**
     * INTERNAL
     */
    public void throwPersistenceUnitMetadataConflict(String element) {
        throw ValidationException.persistenceUnitMetadataConflict(element);
    }
    
    /**
     * INTERNAL
     */
    public void throwRelationshipHasColumnSpecified(Class entityClass, String attributeName) {
        throw ValidationException.invalidColumnElementOnRelationship(entityClass, attributeName);
    }
    
    /**
     * INTERNAL:
     */  
    public void throwSequenceGeneratorUsingAReservedName(String document, String reservedName) {
        throw ValidationException.sequenceGeneratorUsingAReservedName(reservedName, document);
    }
    
    /**
     * INTERNAL:
     */  
    public void throwTableGeneratorUsingAReservedName(String document, String reservedName) {
        throw ValidationException.tableGeneratorUsingAReservedName(reservedName, document);
    }
    
    /**
     * INTERNAL
     */
    public void throwUniDirectionalOneToManyHasJoinColumnSpecified(String attributeName, Class entityClass) {
        throw ValidationException.uniDirectionalOneToManyHasJoinColumnElements(attributeName, entityClass);
    }
}
