/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.queries;

import java.util.List;
import java.util.ArrayList;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataFieldResult;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataEntityResult;

/**
 * Object to hold onto an xml entity result metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLEntityResult extends MetadataEntityResult {
    protected Node m_node;
    protected XMLHelper m_helper;

    /**
     * INTERNAL:
     */
    public XMLEntityResult(Node node, XMLHelper helper) {
        m_node = node;
        m_helper = helper;
    }
    
    /**
     * INTERNAL:
     */
    public String getDiscriminatorColumn() {
        return m_helper.getNodeValue(m_node, XMLConstants.ATT_DISCRIMINATOR_COLUMN, "");
    }
    
    /**
     * INTERNAL:
     * Note this attribute is required but we send in the default void.class
     * object to ensure we go through the correct class loading.
     */
    public Class getEntityClass() {
        return m_helper.getNodeValue(m_node, XMLConstants.ATT_ENTITY_CLASS, void.class);
    }
    
    /**
     * INTERNAL:
     */
    public List<MetadataFieldResult> getFieldResults() {
        if (m_fieldResults == null) {
            m_fieldResults = new ArrayList<MetadataFieldResult>();
            NodeList fieldResultNodes = m_helper.getNodes(m_node, XMLConstants.FIELD_RESULT);
            
            if (fieldResultNodes != null) {
                for (int i = 0; i < fieldResultNodes.getLength(); i++) {
                    m_fieldResults.add(new XMLFieldResult(fieldResultNodes.item(i), m_helper));
                }
            }
        }
        
        return m_fieldResults;
    }
}
