/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.tables;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;
import oracle.toplink.essentials.internal.helper.DatabaseTable;

import java.util.List;
import java.util.ArrayList;

/**
 * Object to hold onto an XML table metadata in a TopLink database table.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLTableHelper {
    /**
     * INTERNAL:
     * Process the unique-constraints for a given table node.
     */
    public static void processUniqueConstraints(Node node, XMLHelper helper, DatabaseTable table) {
        NodeList uniqueConstraintNodes = helper.getNodes(node, XMLConstants.UNIQUE_CONSTRAINTS);
        
        if (uniqueConstraintNodes != null) {
            for (int i = 0; i < uniqueConstraintNodes.getLength(); i++) {
                NodeList columnNameNodes = helper.getTextColumnNodes(uniqueConstraintNodes.item(i));
                
                if (columnNameNodes != null) {
                    List<String> columnNames = new ArrayList<String>(columnNameNodes.getLength());
                    for (int k = 0; k < columnNameNodes.getLength(); k++) {
                        String columnName = columnNameNodes.item(k).getNodeValue();
                        
                        if (columnName != null && !columnName.equals("")) {
                            columnNames.add(columnName);
                        }
                    }
                    if (columnNames.size() > 0) {
                        table.addUniqueConstraints(columnNames.toArray(new String[0]));
                    }
                }
            }
        }
    }
}
