/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.descriptors.DescriptorQueryManager;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.AggregateChangeRecord;
import oracle.toplink.essentials.internal.sessions.CommitManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DoesExistQuery;
import oracle.toplink.essentials.queryframework.ModifyQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;

public abstract class DatabaseQueryMechanism
implements Cloneable,
Serializable {
    protected DatabaseQuery query;

    public DatabaseQueryMechanism() {
    }

    public DatabaseQueryMechanism(DatabaseQuery query) {
        this.query = query;
    }

    protected void addWriteLockFieldForInsert() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().setupWriteFieldsForInsert(this.getWriteObjectQuery());
        }
    }

    public void buildSelectionCriteria(AbstractSession session) {
    }

    public Object checkCacheForObject(AbstractRecord translationRow, AbstractSession session) {
        if (translationRow == null || translationRow.isEmpty()) {
            return null;
        }
        List<DatabaseField> keyFields = this.getDescriptor().getPrimaryKeyFields();
        Vector<Object> primaryKey = new Vector<Object>(keyFields.size());
        for (int index = 0; index < keyFields.size(); ++index) {
            Object value = translationRow.get(keyFields.get(index));
            if (value == null) {
                return null;
            }
            primaryKey.add(value);
        }
        return session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(primaryKey, this.getReadObjectQuery().getReferenceClass(), false, this.getDescriptor());
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public DatabaseQueryMechanism clone(DatabaseQuery queryClone) {
        DatabaseQueryMechanism clone = (DatabaseQueryMechanism)this.clone();
        clone.setQuery(queryClone);
        return clone;
    }

    public abstract DatabaseCall cursorSelectAllRows() throws DatabaseException;

    public boolean isEJBQLCallQueryMechanism() {
        return false;
    }

    public Object buildObjectsFromRows(Vector rows) throws DatabaseException {
        Object result = ((ReadAllQuery)this.getQuery()).getContainerPolicy().containerInstance(rows.size());
        return this.getDescriptor().getObjectBuilder().buildObjectsInto((ReadAllQuery)this.getQuery(), rows, result);
    }

    public abstract Integer deleteAll() throws DatabaseException;

    public abstract Integer deleteObject() throws DatabaseException;

    public abstract Integer executeNoSelect() throws DatabaseException;

    public abstract Vector executeSelect() throws DatabaseException;

    public Object executeWrite() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        CommitManager commitManager = this.getSession().getCommitManager();
        if (commitManager.isCommitCompleted(object) || commitManager.isCommitInPostModify(object)) {
            return object;
        }
        if (commitManager.isCommitInPreModify(object)) {
            this.shallowInsertObjectForWrite(object, writeQuery, commitManager);
            return object;
        }
        try {
            this.getSession().beginTransaction();
            if (writeQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(0, writeQuery));
            }
            writeQuery.executeCommit();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(1, writeQuery));
            }
            this.getSession().commitTransaction();
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException exception) {
            this.getSession().rollbackTransaction();
            commitManager.markCommitCompleted(object);
            throw exception;
        }
    }

    public Object executeWriteWithChangeSet() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
        CommitManager commitManager = this.getSession().getCommitManager();
        if (!objectChangeSet.hasChanges() && !objectChangeSet.hasForcedChanges()) {
            commitManager.markCommitCompleted(objectChangeSet);
            commitManager.markCommitCompleted(writeQuery.getObject());
            return writeQuery.getObject();
        }
        if (commitManager.isCommitCompleted(objectChangeSet) || commitManager.isCommitInPostModify(objectChangeSet)) {
            return writeQuery.getObject();
        }
        if (commitManager.isCommitCompleted(writeQuery.getObject()) || commitManager.isCommitInPostModify(writeQuery.getObject())) {
            return writeQuery.getObject();
        }
        try {
            this.getSession().beginTransaction();
            writeQuery.executeCommitWithChangeSet();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(1, writeQuery));
            }
            this.getSession().commitTransaction();
            commitManager.markCommitCompleted(objectChangeSet);
            commitManager.markCommitCompleted(writeQuery.getObject());
            return writeQuery.getObject();
        }
        catch (RuntimeException exception) {
            this.getSession().rollbackTransaction();
            commitManager.markCommitCompleted(objectChangeSet);
            commitManager.markCommitCompleted(writeQuery.getObject());
            throw exception;
        }
    }

    protected ClassDescriptor getDescriptor() {
        return this.getQuery().getDescriptor();
    }

    public AbstractRecord getModifyRow() {
        if (this.getQuery().isModifyQuery()) {
            return ((ModifyQuery)this.getQuery()).getModifyRow();
        }
        return null;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    protected ReadObjectQuery getReadObjectQuery() {
        return (ReadObjectQuery)this.getQuery();
    }

    public Expression getSelectionCriteria() {
        return null;
    }

    protected AbstractSession getSession() {
        return this.getQuery().getSession();
    }

    protected AbstractRecord getTranslationRow() {
        return this.getQuery().getTranslationRow();
    }

    protected WriteObjectQuery getWriteObjectQuery() {
        return (WriteObjectQuery)this.getQuery();
    }

    public abstract void insertObject() throws DatabaseException;

    public void insertObject(boolean reprepare) {
        this.insertObject();
    }

    public void insertObjectForWrite() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        if (!writeQuery.isUserDefined() && queryManager.hasInsertQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedInsert();
            return;
        }
        CommitManager commitManager = this.getSession().getCommitManager();
        commitManager.markPreModifyCommitInProgress(object);
        if (writeQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(4, writeQuery));
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preInsert(writeQuery);
        }
        if (commitManager.isShallowCommitted(object)) {
            this.updateForeignKeyFieldAfterInsert();
        } else {
            AbstractRecord modifyRow = writeQuery.getModifyRow();
            if (modifyRow == null) {
                if (writeQuery.shouldCascadeParts()) {
                    writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(object, this.getSession()));
                } else {
                    writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForShallowInsert(object, this.getSession()));
                }
            } else if (writeQuery.shouldCascadeParts()) {
                writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(modifyRow, object, this.getSession()));
            } else {
                writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForShallowInsert(modifyRow, object, this.getSession()));
            }
            writeQuery.setTranslationRow(this.getModifyRow());
            if (!writeQuery.getDescriptor().isAggregateCollectionDescriptor()) {
                writeQuery.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession()));
            }
            this.addWriteLockFieldForInsert();
            int modifyRowSize = this.getModifyRow().size();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(12, writeQuery);
                event.setRecord(this.getModifyRow());
                this.getDescriptor().getEventManager().executeEvent(event);
            }
            this.insertObject(modifyRowSize != this.getModifyRow().size());
            this.registerObjectInIdentityMap();
            if (writeQuery.getObjectChangeSet() != null) {
                ((UnitOfWorkChangeSet)writeQuery.getObjectChangeSet().getUOWChangeSet()).putNewObjectInChangesList(writeQuery.getObjectChangeSet(), this.getSession());
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postInsert(writeQuery);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(5, writeQuery));
        }
    }

    public void insertObjectForWriteWithChangeSet() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        CommitManager commitManager = this.getSession().getCommitManager();
        if (!writeQuery.isUserDefined() && queryManager.hasInsertQuery() && this.isExpressionQueryMechanism()) {
            commitManager.markPreModifyCommitInProgress(objectChangeSet);
            this.performUserDefinedInsert();
            return;
        }
        commitManager.markPreModifyCommitInProgress(objectChangeSet);
        commitManager.markPreModifyCommitInProgress(writeQuery.getObject());
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preInsert(writeQuery);
        }
        if (commitManager.isShallowCommitted(objectChangeSet)) {
            this.updateForeignKeyFieldAfterInsert();
        } else {
            AbstractRecord modifyRow = writeQuery.getModifyRow();
            if (modifyRow == null) {
                if (writeQuery.shouldCascadeParts()) {
                    writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowWithChangeSet(objectChangeSet, this.getSession()));
                } else {
                    writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForShallowInsertWithChangeSet(objectChangeSet, this.getSession()));
                }
            } else if (writeQuery.shouldCascadeParts()) {
                writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowWithChangeSet(modifyRow, objectChangeSet, this.getSession()));
            } else {
                writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForShallowInsertWithChangeSet(modifyRow, objectChangeSet, this.getSession()));
            }
            writeQuery.setTranslationRow(this.getModifyRow());
            if (!writeQuery.getDescriptor().isAggregateCollectionDescriptor()) {
                writeQuery.setPrimaryKey(objectChangeSet.getPrimaryKeys());
            }
            this.addWriteLockFieldForInsert();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(12, writeQuery);
                event.setRecord(this.getModifyRow());
                this.getDescriptor().getEventManager().executeEvent(event);
            }
            this.insertObject();
            this.registerObjectInIdentityMap();
            if (objectChangeSet != null) {
                ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).putNewObjectInChangesList(objectChangeSet, this.getSession());
            }
        }
        commitManager.markPostModifyCommitInProgress(objectChangeSet);
        commitManager.markPostModifyCommitInProgress(writeQuery.getObject());
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postInsert(writeQuery);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(5, writeQuery));
        }
    }

    public boolean isCallQueryMechanism() {
        return false;
    }

    public boolean isExpressionQueryMechanism() {
        return false;
    }

    public boolean isQueryByExampleMechanism() {
        return false;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    protected void performUserDefinedInsert() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getInsertQuery());
    }

    protected void performUserDefinedUpdate() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getUpdateQuery());
    }

    protected void performUserDefinedWrite(WriteObjectQuery userDefinedWriteQuery) {
        userDefinedWriteQuery.checkPrepare(this.getSession(), this.getTranslationRow());
        Object object = this.getWriteObjectQuery().getObject();
        WriteObjectQuery writeQuery = (WriteObjectQuery)userDefinedWriteQuery.clone();
        writeQuery.setObject(object);
        writeQuery.setObjectChangeSet(this.getWriteObjectQuery().getObjectChangeSet());
        writeQuery.setCascadePolicy(this.getQuery().getCascadePolicy());
        writeQuery.setShouldMaintainCache(this.getQuery().shouldMaintainCache());
        writeQuery.setTranslationRow(this.getTranslationRow());
        writeQuery.setModifyRow(this.getModifyRow());
        writeQuery.setPrimaryKey(this.getWriteObjectQuery().getPrimaryKey());
        writeQuery.setSession(this.getSession());
        writeQuery.prepareForExecution();
        if (this.getWriteObjectQuery().isUpdateObjectQuery() && this.getWriteObjectQuery().getObjectChangeSet() != null) {
            writeQuery.executeCommitWithChangeSet();
        } else {
            writeQuery.executeCommit();
        }
    }

    public void prepare() throws QueryException {
    }

    public abstract void prepareCursorSelectAllRows() throws QueryException;

    public abstract void prepareDeleteAll() throws QueryException;

    public abstract void prepareDeleteObject() throws QueryException;

    public abstract void prepareDoesExist(DatabaseField var1) throws QueryException;

    public abstract void prepareExecuteNoSelect() throws QueryException;

    public abstract void prepareExecuteSelect() throws QueryException;

    public void prepareForExecution() throws QueryException {
    }

    public abstract void prepareInsertObject() throws QueryException;

    public abstract void prepareReportQuerySelectAllRows() throws QueryException;

    public abstract void prepareReportQuerySubSelect() throws QueryException;

    public abstract void prepareSelectAllRows() throws QueryException;

    public abstract void prepareSelectOneRow() throws QueryException;

    public abstract void prepareUpdateObject() throws QueryException;

    public abstract void prepareUpdateAll() throws QueryException;

    protected void registerObjectInIdentityMap() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        if (writeQuery.shouldMaintainCache()) {
            if (this.getDescriptor().usesOptimisticLocking()) {
                Object optimisticLockValue = this.getDescriptor().getOptimisticLockingPolicy().getValueToPutInCache(writeQuery.getModifyRow(), this.getSession());
                this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(object, writeQuery.getPrimaryKey(), optimisticLockValue, System.currentTimeMillis(), this.getDescriptor());
            } else {
                this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(object, writeQuery.getPrimaryKey(), null, System.currentTimeMillis(), this.getDescriptor());
            }
        }
    }

    public abstract Vector selectAllReportQueryRows() throws DatabaseException;

    public abstract Vector selectAllRows() throws DatabaseException;

    public abstract AbstractRecord selectOneRow() throws DatabaseException;

    public abstract AbstractRecord selectRowForDoesExist(DatabaseField var1) throws DatabaseException;

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    protected void shallowInsertObjectForWrite(Object object, WriteObjectQuery writeQuery, CommitManager commitManager) throws DatabaseException, OptimisticLockException {
        boolean doesExist;
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl uow = (UnitOfWorkImpl)this.getSession();
            boolean bl = doesExist = !uow.isCloneNewObject(object);
            if (doesExist) {
                doesExist = uow.isObjectRegistered(object);
            }
        } else {
            DoesExistQuery existQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            existQuery.setObject(object);
            existQuery.setPrimaryKey(writeQuery.getPrimaryKey());
            existQuery.setDescriptor(this.getDescriptor());
            existQuery.setTranslationRow(this.getTranslationRow());
            doesExist = (Boolean)this.getSession().executeQuery(existQuery);
        }
        if (!doesExist) {
            writeQuery.dontCascadeParts();
            this.insertObjectForWrite();
            commitManager.markShallowCommit(object);
        }
    }

    protected void updateForeignKeyFieldAfterInsert() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        writeQuery.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession()));
        writeQuery.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, this.getSession()));
        this.updateForeignKeyFieldAfterInsert(writeQuery);
    }

    public abstract Integer updateAll() throws DatabaseException;

    public abstract Integer updateObject() throws DatabaseException;

    protected abstract void updateForeignKeyFieldAfterInsert(WriteObjectQuery var1);

    protected void updateObjectAndRowWithReturnRow(Collection returnFields, boolean isFirstCallForInsert) {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        AbstractRecord outputRow = (AbstractRecord)writeQuery.getProperties().get("output");
        if (outputRow == null || outputRow.isEmpty()) {
            return;
        }
        DatabaseRecord row = new DatabaseRecord();
        for (DatabaseField field : returnFields) {
            if (!outputRow.containsKey(field)) continue;
            row.put(field, outputRow.get(field));
        }
        if (((AbstractRecord)row).isEmpty()) {
            return;
        }
        Object object = writeQuery.getObject();
        this.getDescriptor().getObjectBuilder().assignReturnRow(object, this.getSession(), row);
        Vector primaryKeys = null;
        if (isFirstCallForInsert) {
            DatabaseRecord pkToModify = new DatabaseRecord();
            List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
            for (int i = 0; i < primaryKeyFields.size(); ++i) {
                DatabaseField field = primaryKeyFields.get(i);
                if (!row.containsKey(field)) continue;
                pkToModify.put(field, row.get(field));
            }
            if (!((AbstractRecord)pkToModify).isEmpty()) {
                primaryKeys = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
                writeQuery.setPrimaryKey(primaryKeys);
                this.getModifyRow().putAll((Map)pkToModify);
                this.getDescriptor().getObjectBuilder().addPrimaryKeyForNonDefaultTable(this.getModifyRow());
            }
        }
        if (this.getSession().isUnitOfWork()) {
            ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
            if (objectChangeSet == null && ((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet() != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (objectChangeSet != null) {
                this.updateChangeSet(this.getDescriptor(), objectChangeSet, row, object);
                if (primaryKeys != null) {
                    objectChangeSet.setCacheKey(new CacheKey(primaryKeys));
                }
            }
        }
    }

    public void updateChangeSet(ClassDescriptor desc, ObjectChangeSet objectChangeSet, AbstractRecord row, Object object) {
        HashSet handledMappings = new HashSet(row.size());
        for (int i = 0; i < row.size(); ++i) {
            DatabaseField field = (DatabaseField)row.getFields().elementAt(i);
            Object value = row.getValues().elementAt(i);
            this.updateChangeSet(desc, objectChangeSet, field, object, handledMappings);
        }
    }

    protected void updateChangeSet(ClassDescriptor desc, ObjectChangeSet objectChangeSet, DatabaseField field, Object object) {
        this.updateChangeSet(desc, objectChangeSet, field, object, null);
    }

    protected void updateChangeSet(ClassDescriptor desc, ObjectChangeSet objectChangeSet, DatabaseField field, Object object, Collection handledMappings) {
        DatabaseMapping mapping;
        Vector<DatabaseMapping> mappingVector = desc.getObjectBuilder().getReadOnlyMappingsForField(field);
        if (mappingVector != null) {
            for (int j = 0; j < mappingVector.size(); ++j) {
                mapping = mappingVector.elementAt(j);
                this.updateChangeSet(mapping, objectChangeSet, field, object, handledMappings);
            }
        }
        if ((mapping = desc.getObjectBuilder().getMappingForField(field)) != null) {
            this.updateChangeSet(mapping, objectChangeSet, field, object, handledMappings);
        }
    }

    protected void updateChangeSet(DatabaseMapping mapping, ObjectChangeSet objectChangeSet, DatabaseField field, Object object, Collection handledMappings) {
        if (handledMappings != null && handledMappings.contains(mapping)) {
            return;
        }
        if (mapping.isAggregateObjectMapping()) {
            Object aggregate = mapping.getAttributeValueFromObject(object);
            AggregateChangeRecord record = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(mapping.getAttributeName());
            if (aggregate != null) {
                if (record == null) {
                    record = new AggregateChangeRecord(objectChangeSet);
                    record.setAttribute(mapping.getAttributeName());
                    record.setMapping(mapping);
                    objectChangeSet.addChange(record);
                }
                ObjectChangeSet aggregateChangeSet = (ObjectChangeSet)record.getChangedObject();
                ClassDescriptor aggregateDescriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
                if (aggregateChangeSet == null) {
                    aggregateChangeSet = aggregateDescriptor.getObjectBuilder().createObjectChangeSet(aggregate, (UnitOfWorkChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet(), this.getSession());
                    record.setChangedObject(aggregateChangeSet);
                }
                this.updateChangeSet(aggregateDescriptor, aggregateChangeSet, field, aggregate, handledMappings);
            } else if (record != null) {
                record.setChangedObject(null);
            }
        } else if (mapping.isDirectToFieldMapping()) {
            Object attributeValue = mapping.getAttributeValueFromObject(object);
            objectChangeSet.updateChangeRecordForAttribute(mapping, attributeValue);
        } else {
            this.getSession().log(1, "query", "field_for_unsupported_mapping_returned", field, this.getDescriptor());
        }
    }

    protected void updateObjectAndRowWithSequenceNumber() throws DatabaseException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        Object sequenceValue = this.getDescriptor().getObjectBuilder().assignSequenceNumber(object, this.getSession());
        if (sequenceValue == null) {
            return;
        }
        Vector primaryKeys = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        writeQuery.setPrimaryKey(primaryKeys);
        DatabaseField sequenceNumberField = this.getDescriptor().getSequenceNumberField();
        this.getModifyRow().put(sequenceNumberField, sequenceValue);
        this.getDescriptor().getObjectBuilder().addPrimaryKeyForNonDefaultTable(this.getModifyRow());
        if (this.getSession().isUnitOfWork()) {
            ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
            if (objectChangeSet == null && ((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet() != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (objectChangeSet != null) {
                this.updateChangeSet(this.getDescriptor(), objectChangeSet, sequenceNumberField, object);
                objectChangeSet.setCacheKey(new CacheKey(primaryKeys));
            }
        }
    }

    public void updateObjectForWrite() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        if (!writeQuery.isUserDefined() && queryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedUpdate();
            return;
        }
        this.getSession().getCommitManager().markPreModifyCommitInProgress(object);
        if (writeQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(6, writeQuery));
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preUpdate(writeQuery);
        }
        if ((writeQuery.isUserDefined() || writeQuery.isCallQuery()) && !this.getSession().isUnitOfWork()) {
            writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(object, this.getSession()));
        } else {
            writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForUpdate(writeQuery));
        }
        if (!this.getModifyRow().isEmpty()) {
            int rowCount;
            if ((writeQuery.isUserDefined() || writeQuery.isCallQuery()) && this.getSession().isUnitOfWork()) {
                writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(object, this.getSession()));
            }
            if (this.getDescriptor().usesOptimisticLocking()) {
                OptimisticLockingPolicy policy = this.getDescriptor().getOptimisticLockingPolicy();
                policy.addLockValuesToTranslationRow(writeQuery);
                policy.updateRowAndObjectForUpdate(writeQuery, object);
            }
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(13, writeQuery);
                event.setRecord(this.getModifyRow());
                this.getDescriptor().getEventManager().executeEvent(event);
            }
            if ((rowCount = this.updateObject().intValue()) < 1) {
                this.getSession().getEventManager().noRowsModified(writeQuery, object);
            }
            if (this.getDescriptor().usesOptimisticLocking()) {
                this.getDescriptor().getOptimisticLockingPolicy().validateUpdate(rowCount, object, writeQuery);
            }
        }
        this.getSession().getCommitManager().markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postUpdate(writeQuery);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(7, writeQuery));
        }
    }

    public void updateObjectForWriteWithChangeSet() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        if (!writeQuery.isUserDefined() && queryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            this.getSession().getCommitManager().markPreModifyCommitInProgress(writeQuery.getObjectChangeSet());
            this.performUserDefinedUpdate();
            return;
        }
        this.getSession().getCommitManager().markPreModifyCommitInProgress(object);
        this.getSession().getCommitManager().markPreModifyCommitInProgress(writeQuery.getObjectChangeSet());
        if (writeQuery.getObjectChangeSet().hasChanges() && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(17, writeQuery);
            this.getDescriptor().getEventManager().executeEvent(event);
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeQuery.getSession()).getUnitOfWorkChangeSet();
            writeQuery.getObjectChangeSet().clear();
            if (writeQuery.getDescriptor().getObjectChangePolicy().calculateChanges(object, ((UnitOfWorkImpl)event.getSession()).getBackupClone(object), uowChangeSet, writeQuery.getSession(), writeQuery.getDescriptor(), false) == null) {
                uowChangeSet.getAllChangeSets().remove(writeQuery.getObjectChangeSet());
            }
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preUpdate(writeQuery);
        }
        writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForUpdateWithChangeSet(writeQuery));
        Boolean shouldModifyVersionField = writeQuery.getObjectChangeSet().shouldModifyVersionField();
        if (!this.getModifyRow().isEmpty() || shouldModifyVersionField != null || writeQuery.getObjectChangeSet().hasCmpPolicyForcedUpdate()) {
            int rowCount;
            if (writeQuery.isUserDefined() || writeQuery.isCallQuery()) {
                writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(object, this.getSession()));
            }
            if (this.getDescriptor().usesOptimisticLocking()) {
                OptimisticLockingPolicy policy = this.getDescriptor().getOptimisticLockingPolicy();
                policy.addLockValuesToTranslationRow(writeQuery);
                if (!this.getModifyRow().isEmpty() || shouldModifyVersionField.booleanValue() && policy instanceof VersionLockingPolicy) {
                    policy.updateRowAndObjectForUpdate(writeQuery, object);
                } else if (!shouldModifyVersionField.booleanValue() && policy instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)policy).writeLockValueIntoRow(writeQuery, object);
                }
            }
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(13, writeQuery);
                event.setRecord(this.getModifyRow());
                this.getDescriptor().getEventManager().executeEvent(event);
            }
            if ((rowCount = this.updateObject().intValue()) < 1) {
                this.getSession().getEventManager().noRowsModified(writeQuery, object);
            }
            if (this.getDescriptor().usesOptimisticLocking()) {
                this.getDescriptor().getOptimisticLockingPolicy().validateUpdate(rowCount, object, writeQuery);
            }
        }
        this.getSession().getCommitManager().markPostModifyCommitInProgress(object);
        this.getSession().getCommitManager().markPostModifyCommitInProgress(writeQuery.getObjectChangeSet());
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postUpdate(writeQuery);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(7, writeQuery));
        }
    }
}

