/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sessions;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.sessions.Connector;

public class DefaultConnector
implements Connector {
    protected String driverClassName;
    protected String driverURLHeader;
    protected String databaseURL;

    public DefaultConnector() {
        this("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:", "");
    }

    public DefaultConnector(String driverClassName, String driverURLHeader, String databaseURL) {
        this.initialize(driverClassName, driverURLHeader, databaseURL);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public Connection connect(Properties properties) throws DatabaseException {
        this.loadDriver();
        try {
            return DriverManager.getConnection(this.getConnectionString(), properties);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception);
        }
    }

    public String getConnectionString() {
        return this.getDriverURLHeader() + this.getDatabaseURL();
    }

    public String getConnectionDetails() {
        return this.getConnectionString();
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDriverURLHeader() {
        return this.driverURLHeader;
    }

    protected void initialize(String driverClassName, String driverURLHeader, String databaseURL) {
        this.setDriverClassName(driverClassName);
        this.setDriverURLHeader(driverURLHeader);
        this.setDatabaseURL(databaseURL);
    }

    protected Class loadDriver() throws DatabaseException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getDriverClassName(), true, ConversionManager.getDefaultManager().getLoader()));
                }
                catch (PrivilegedActionException exception) {
                    throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
                }
            }
            return PrivilegedAccessHelper.getClassForName(this.getDriverClassName(), true, ConversionManager.getDefaultManager().getLoader());
        }
        catch (ClassNotFoundException exception) {
            throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
        }
    }

    public void setDatabaseURL(String databaseURL) {
        this.databaseURL = databaseURL;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setDriverURLHeader(String driverURLHeader) {
        this.driverURLHeader = driverURLHeader;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getConnectionString() + ")";
    }

    public void toString(PrintWriter writer) {
        writer.println(ToStringLocalization.buildMessage("datasource_URL", null) + "=> \"" + this.getConnectionString() + "\"");
    }
}

