/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.queries;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataQueryHint;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataNamedNativeQuery;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Object to hold onto an XML named native query metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLNamedNativeQuery extends MetadataNamedNativeQuery {
    /**
     * INTERNAL:
     */
    public XMLNamedNativeQuery(Node node, XMLHelper helper) {
        // Set the location where we found this query.
        setLocation(helper.getDocumentName());
        
        // Process the name.
        setName(helper.getNodeValue(node, XMLConstants.ATT_NAME));
        
        // Process the query string.
        setEJBQLString(helper.getNodeTextValue(node, XMLConstants.QUERY));
        
        // Process the query hints.
        NodeList hints = helper.getNodes(node, XMLConstants.QUERY_HINT);
        if (hints != null) {
            for (int i = 0; i < hints.getLength(); i++) {
                Node hintNode = hints.item(i);
                String name = helper.getNodeValue(hintNode, XMLConstants.ATT_NAME);
                String value = helper.getNodeValue(hintNode, XMLConstants.ATT_VALUE);
                addHint(new MetadataQueryHint(name, value));
            }
        }
            
        // Process the result class.
        setResultClass(helper.getNodeValue(node, XMLConstants.ATT_RESULT_CLASS, void.class));
        
        // Process the result set mapping.
        setResultSetMapping(helper.getNodeValue(node, XMLConstants.ATT_RESULT_SET_MAPPING, ""));
    }
    
    /**
     * INTERNAL:
     */
    public String getIgnoreLogMessageContext() {
        return MetadataLogger.IGNORE_NAMED_NATIVE_QUERY_ELEMENT;
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromAnnotations() {
        return false;
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return true;
    }
}
