/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.ClassExtractor;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedMethodInvoker;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.sessions.Record;
import oracle.toplink.essentials.sessions.Session;

public class MethodClassExtractor
extends ClassExtractor {
    protected transient ClassDescriptor descriptor;
    protected String classExtractionMethodName;
    protected transient Method classExtractionMethod;

    public Method getClassExtractionMethod() {
        return this.classExtractionMethod;
    }

    public String getClassExtractionMethodName() {
        return this.classExtractionMethodName;
    }

    protected void setClassExtractionMethod(Method classExtractionMethod) {
        this.classExtractionMethod = classExtractionMethod;
    }

    public void setClassExtractionMethodName(String staticClassClassExtractionMethod) {
        this.classExtractionMethodName = staticClassClassExtractionMethod;
    }

    public void initialize(ClassDescriptor descriptor, Session session) throws DescriptorException {
        this.setDescriptor(descriptor);
        Class[] declarationParameters = new Class[]{ClassConstants.DatabaseRow_Class};
        try {
            this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), declarationParameters));
        }
        catch (NoSuchMethodException ignore) {
            declarationParameters[0] = ClassConstants.Record_Class;
            try {
                this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), declarationParameters));
            }
            catch (NoSuchMethodException exception) {
                throw DescriptorException.noSuchMethodWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
            }
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
        }
        if (!Modifier.isStatic(this.getClassExtractionMethod().getModifiers())) {
            throw DescriptorException.classExtractionMethodMustBeStatic(this.getClassExtractionMethodName(), descriptor);
        }
    }

    public Class extractClassFromRow(Record row, Session session) {
        Class classForRow;
        block7: {
            try {
                Object[] arguments = new Object[]{row};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        classForRow = (Class)AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getClassExtractionMethod(), null, arguments));
                        break block7;
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), throwableException);
                        }
                        throw DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), throwableException);
                    }
                }
                classForRow = (Class)PrivilegedAccessHelper.invokeMethod(this.getClassExtractionMethod(), null, arguments);
            }
            catch (IllegalAccessException exception) {
                throw DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), exception);
            }
            catch (InvocationTargetException exception) {
                throw DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), exception);
            }
        }
        return classForRow;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

