/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.identitymaps;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.identitymaps.IdentityMap;
import oracle.toplink.essentials.internal.identitymaps.IdentityMapEnumeration;
import oracle.toplink.essentials.internal.identitymaps.IdentityMapKeyEnumeration;

public class FullIdentityMap
extends IdentityMap {
    protected Hashtable cacheKeys;

    public FullIdentityMap(int size) {
        super(size);
        this.cacheKeys = new Hashtable(size);
    }

    public Object clone() {
        FullIdentityMap clone = (FullIdentityMap)super.clone();
        clone.setCacheKeys(new Hashtable(this.getCacheKeys().size()));
        Enumeration cacheKeysEnum = this.getCacheKeys().elements();
        while (cacheKeysEnum.hasMoreElements()) {
            CacheKey key = (CacheKey)((CacheKey)cacheKeysEnum.nextElement()).clone();
            clone.getCacheKeys().put(key, key);
        }
        return clone;
    }

    public void collectLocks(HashMap threadList) {
        for (CacheKey cacheKey : this.cacheKeys.values()) {
            if (!cacheKey.isAcquired()) continue;
            Thread activeThread = cacheKey.getMutex().getActiveThread();
            HashSet<CacheKey> set = (HashSet<CacheKey>)threadList.get(activeThread);
            if (set == null) {
                set = new HashSet<CacheKey>();
                threadList.put(activeThread, set);
            }
            set.add(cacheKey);
        }
    }

    public Enumeration elements() {
        return new IdentityMapEnumeration(this);
    }

    protected synchronized CacheKey getCacheKey(CacheKey searchKey) {
        return (CacheKey)this.getCacheKeys().get(searchKey);
    }

    public Hashtable getCacheKeys() {
        return this.cacheKeys;
    }

    public int getSize() {
        return this.cacheKeys.size();
    }

    public int getSize(Class myClass, boolean recurse) {
        int i = 0;
        Enumeration keys = this.getCacheKeys().keys();
        while (keys.hasMoreElements()) {
            CacheKey key = (CacheKey)keys.nextElement();
            Object obj = key.getObject();
            if (obj == null) continue;
            if (recurse && myClass.isInstance(obj)) {
                ++i;
                continue;
            }
            if (!obj.getClass().equals(myClass)) continue;
            ++i;
        }
        return i;
    }

    public Enumeration keys() {
        return new IdentityMapKeyEnumeration(this);
    }

    public CacheKey put(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey != null) {
            this.resetCacheKey(cacheKey, object, writeLockValue);
            this.put(cacheKey);
        } else {
            cacheKey = this.createCacheKey(primaryKey, object, writeLockValue, readTime);
            this.put(cacheKey);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(CacheKey cacheKey) {
        FullIdentityMap fullIdentityMap = this;
        synchronized (fullIdentityMap) {
            this.getCacheKeys().put(cacheKey, cacheKey);
        }
        cacheKey.setOwningMap(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(CacheKey cacheKey) {
        if (cacheKey != null) {
            cacheKey.acquire();
            FullIdentityMap fullIdentityMap = this;
            synchronized (fullIdentityMap) {
                this.getCacheKeys().remove(cacheKey);
            }
        } else {
            return null;
        }
        cacheKey.release();
        return cacheKey.getObject();
    }

    public void resetCacheKey(CacheKey key, Object object, Object writeLockValue) {
        this.resetCacheKey(key, object, writeLockValue, 0L);
    }

    public void resetCacheKey(CacheKey key, Object object, Object writeLockValue, long readTime) {
        key.acquire();
        key.setObject(object);
        key.setWriteLockValue(writeLockValue);
        key.setReadTime(readTime);
        key.release();
    }

    protected void setCacheKeys(Hashtable cacheKeys) {
        this.cacheKeys = cacheKeys;
    }
}

