/*
 * Decompiled with CFR 0.152.
 */
package uk.co.automatictester.wiremock.maven.plugin.mojo;

import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import uk.co.automatictester.wiremock.maven.plugin.mojo.ConfigurationMojo;
import uk.co.automatictester.wiremock.maven.plugin.server.WireMockServer;
import uk.co.automatictester.wiremock.maven.plugin.util.ClasspathUtil;

@Mojo(name="run", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WireMockRunMojo
extends ConfigurationMojo {
    public void execute() throws MojoExecutionException {
        this.addRuntimeDependenciesToClasspath();
        String[] rawWireMockParams = this.getAllParams();
        String wireMockParams = this.getFormattedStringFrom(rawWireMockParams);
        String startMessage = String.format("Starting WireMock with following params: %s", wireMockParams);
        this.getLog().info((CharSequence)startMessage);
        WireMockServer wireMock = WireMockServer.getInstance();
        wireMock.run(rawWireMockParams);
        if (this.shouldKeepRunning()) {
            this.keepRunningUntilInterrupted();
        }
    }

    private void addRuntimeDependenciesToClasspath() throws MojoExecutionException {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        classpathUtil.setClasspathElements(this.classpathElements);
        classpathUtil.setDescriptor(this.descriptor);
        classpathUtil.addRuntimeDependenciesToClasspath();
    }

    private String getFormattedStringFrom(String[] array) {
        return Arrays.toString(array).replaceAll("[\\[\\]]", "").replaceAll(", ", " ");
    }

    private void keepRunningUntilInterrupted() {
        this.getLog().info((CharSequence)"WireMock will keep running until interrupted manually...");
        while (true) {
            this.sleepForOneSecond();
        }
    }

    private void sleepForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
    }
}

