/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.utility.Query;
import schemacrawler.utility.QueryUtility;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class MetadataResultSet
implements AutoCloseable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(MetadataResultSet.class.getName());
    private static final int FETCHSIZE = 20;
    private String description;
    private final ResultSet results;
    private final List<String> resultSetColumns;
    private Set<String> readColumns;
    private int rowCount;

    MetadataResultSet(Query query, Statement statement, InclusionRule schemaInclusionRule) throws SQLException {
        this(QueryUtility.executeAgainstSchema(query, statement, schemaInclusionRule));
        if (query.hasName()) {
            this.description = query.getName();
        }
    }

    MetadataResultSet(ResultSet resultSet) throws SQLException {
        this.results = Objects.requireNonNull(resultSet, "Cannot use null results");
        try {
            this.results.setFetchSize(20);
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.log(Level.WARNING, "Could not set fetch size", (Throwable)e);
        }
        ArrayList<String> resultSetColumns = new ArrayList<String>();
        try {
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            for (int i = 0; i < rsMetaData.getColumnCount(); ++i) {
                String columnName = rsMetaData.getColumnLabel(i + 1);
                if (Utility.isBlank(columnName)) {
                    columnName = rsMetaData.getColumnName(i + 1);
                }
                resultSetColumns.add(columnName.toUpperCase());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not get columns list");
        }
        this.resultSetColumns = Collections.unmodifiableList(resultSetColumns);
        this.readColumns = new HashSet<String>();
    }

    @Override
    public void close() throws SQLException {
        this.results.close();
        if (LOGGER.isLoggable(Level.INFO) && !Utility.isBlank(this.description)) {
            LOGGER.log(Level.INFO, new StringFormat("Processed %d rows for <%s>", this.rowCount, this.description));
        }
    }

    Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String columnName : this.resultSetColumns) {
            if (this.readColumns.contains(columnName)) continue;
            try {
                Object value = this.results.getObject(columnName);
                attributes.put(columnName, value);
            }
            catch (ArrayIndexOutOfBoundsException | SQLException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not read value for column <%s>", columnName), (Throwable)e);
            }
        }
        return attributes;
    }

    BigInteger getBigInteger(String columnName) {
        BigInteger value;
        String stringBigInteger = this.getString(columnName);
        if (Utility.isBlank(stringBigInteger)) {
            return null;
        }
        stringBigInteger = stringBigInteger.replaceAll("[, ]", stringBigInteger);
        try {
            value = new BigInteger(stringBigInteger);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not get big integer value", (Throwable)e);
            return null;
        }
        return value;
    }

    boolean getBoolean(String columnName) {
        if (this.useColumn(columnName)) {
            try {
                Object booleanValue = this.results.getObject(columnName);
                if (this.results.wasNull() || booleanValue == null) {
                    LOGGER.log(Level.FINER, new StringFormat("NULL value for column <%s>, so evaluating to 'false'", columnName));
                    return false;
                }
                String stringBooleanValue = String.valueOf(booleanValue).trim();
                if (Utility.isIntegral(stringBooleanValue)) {
                    return !stringBooleanValue.equals("0");
                }
                return stringBooleanValue.equalsIgnoreCase("yes") || stringBooleanValue.equalsIgnoreCase("true");
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not read boolean value for column <%s>", columnName), (Throwable)e);
            }
        }
        return false;
    }

    <E extends Enum<E>> E getEnum(String columnName, E defaultValue) {
        String value = this.getString(columnName);
        if (Utility.isBlank(value)) {
            return defaultValue;
        }
        return Utility.enumValue(value.toLowerCase(Locale.ENGLISH), defaultValue);
    }

    <E extends Enum<E>> E getEnumFromId(String columnName, E defaultValue) {
        int value = this.getInt(columnName, 0);
        return Utility.enumValueFromId(value, defaultValue);
    }

    <E extends Enum<E>> E getEnumFromShortId(String columnName, E defaultValue) {
        short value = this.getShort(columnName, (short)0);
        return Utility.enumValueFromId(value, defaultValue);
    }

    int getInt(String columnName, int defaultValue) {
        int value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getInt(columnName);
                if (this.results.wasNull()) {
                    LOGGER.log(Level.FINER, new StringFormat("NULL int value for column <%s>, so using default %d", columnName, defaultValue));
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not read integer value for column <%s>", columnName), (Throwable)e);
            }
        }
        return value;
    }

    long getLong(String columnName, long defaultValue) {
        long value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getLong(columnName);
                if (this.results.wasNull()) {
                    LOGGER.log(Level.FINER, new StringFormat("NULL long value for column <%s>, so using default %d", columnName, defaultValue));
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not read long value for column <%s>", columnName), (Throwable)e);
            }
        }
        return value;
    }

    short getShort(String columnName, short defaultValue) {
        short value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getShort(columnName);
                if (this.results.wasNull()) {
                    LOGGER.log(Level.FINER, new StringFormat("NULL short value for column <%s>, so using default %d", columnName, defaultValue));
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not read short value for column <%s>", columnName), (Throwable)e);
            }
        }
        return value;
    }

    String getString(String columnName) {
        String value = null;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getString(columnName);
                if (this.results.wasNull()) {
                    value = null;
                }
                if (value != null) {
                    value = value.trim();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not read string value for column <%s>", columnName), (Throwable)e);
            }
        }
        return value;
    }

    boolean next() throws SQLException {
        this.readColumns = new HashSet<String>();
        boolean next = this.results.next();
        DatabaseUtility.logSQLWarnings(this.results);
        if (next) {
            ++this.rowCount;
        }
        return next;
    }

    void setDescription(String description) {
        this.description = description;
    }

    private boolean useColumn(String columnName) {
        boolean useColumn;
        boolean bl = useColumn = columnName != null && this.resultSetColumns.contains(columnName);
        if (useColumn) {
            this.readColumns.add(columnName);
        }
        return useColumn;
    }
}

