/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.crawl.MutableFunctionColumn;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Function;
import schemacrawler.schema.FunctionColumn;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;

final class MutableFunction
extends MutableRoutine
implements Function {
    private static final long serialVersionUID = 3906925686089134130L;
    private FunctionReturnType returnType;
    private final NamedObjectList<MutableFunctionColumn> columns = new NamedObjectList();

    MutableFunction(Schema schema, String name) {
        super(schema, name);
        this.returnType = FunctionReturnType.unknown;
    }

    @Override
    public List<FunctionColumn> getColumns() {
        return new ArrayList<FunctionColumn>(this.columns.values());
    }

    @Override
    public FunctionReturnType getReturnType() {
        return this.returnType;
    }

    @Override
    public RoutineType getRoutineType() {
        return RoutineType.function;
    }

    public Optional<MutableFunctionColumn> lookupColumn(String name) {
        return this.columns.lookup(this, name);
    }

    void addColumn(MutableFunctionColumn column) {
        this.columns.add(column);
    }

    void setReturnType(FunctionReturnType returnType) {
        this.returnType = Objects.requireNonNull(returnType, "Null function return type");
    }
}

