/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.ReducibleCollection;
import sf.util.ObjectToString;

final class NamedObjectList<N extends NamedObject>
implements Serializable,
ReducibleCollection<N> {
    private static final long serialVersionUID = 3257847666804142128L;
    private final Map<List<String>, N> objects = new HashMap<List<String>, N>();

    NamedObjectList() {
    }

    private static List<String> makeLookupKey(NamedObject namedObject) {
        List<String> key = namedObject == null ? null : namedObject.toUniqueLookupKey();
        return key;
    }

    private static List<String> makeLookupKey(NamedObject namedObject, String name) {
        List<String> key = NamedObjectList.makeLookupKey(namedObject);
        if (key != null) {
            key.add(name);
        }
        return key;
    }

    @Override
    public void filter(Predicate<? super N> predicate) {
        if (predicate == null) {
            return;
        }
        Set<Map.Entry<List<String>, N>> entrySet = this.objects.entrySet();
        Iterator<Map.Entry<List<String>, N>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<List<String>, N> entry = iterator.next();
            if (predicate.test(entry.getValue())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean isFiltered(NamedObject object) {
        return !this.contains(object);
    }

    @Override
    public Iterator<N> iterator() {
        final class UnmodifiableIterator
        implements Iterator<N> {
            private final Iterator<N> iterator;

            UnmodifiableIterator(Iterator<N> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public N next() {
                return (NamedObject)this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new UnmodifiableIterator(this.values().iterator());
    }

    public String toString() {
        return ObjectToString.toString(this.values());
    }

    boolean add(N namedObject) {
        Objects.requireNonNull(namedObject, "Cannot add a null object to the list");
        List<String> key = NamedObjectList.makeLookupKey(namedObject);
        this.objects.put(key, namedObject);
        return true;
    }

    boolean contains(NamedObject namedObject) {
        return this.objects.containsKey(NamedObjectList.makeLookupKey(namedObject));
    }

    boolean isEmpty() {
        return this.objects.isEmpty();
    }

    Optional<N> lookup(List<String> lookupKey) {
        return this.internalGet(lookupKey);
    }

    Optional<N> lookup(NamedObject namedObject, String name) {
        List<String> key = NamedObjectList.makeLookupKey(namedObject, name);
        return this.internalGet(key);
    }

    N remove(N namedObject) {
        return (N)((NamedObject)this.objects.remove(NamedObjectList.makeLookupKey(namedObject)));
    }

    int size() {
        return this.objects.size();
    }

    List<N> values() {
        ArrayList<N> all = new ArrayList<N>(this.objects.values());
        all.sort(Comparator.naturalOrder());
        return all;
    }

    private Optional<N> internalGet(List<String> key) {
        return Optional.ofNullable(this.objects.get(key));
    }
}

