/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableProcedureColumn;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.ProcedureColumnType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class ProcedureColumnRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ProcedureColumnRetriever.class.getName());

    ProcedureColumnRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveProcedureColumns(NamedObjectList<MutableRoutine> allRoutines, InclusionRule columnInclusionRule) throws SQLException {
        Objects.requireNonNull(allRoutines, "No procedures provided");
        InclusionRuleFilter<ProcedureColumn> columnFilter = new InclusionRuleFilter<ProcedureColumn>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving procedure columns, since this was not requested");
            return;
        }
        MetadataRetrievalStrategy procedureColumnRetrievalStrategy = this.getRetrieverConnection().getProcedureColumnRetrievalStrategy();
        switch (procedureColumnRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving procedure columns, using fast data dictionary retrieval");
                this.retrieveProcedureColumnsFromDataDictionary(allRoutines, columnFilter);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving procedure columns, using fast meta-data retrieval");
                this.retrieveProcedureColumnsFromMetadataForAllProcedures(allRoutines, columnFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving procedure columns");
                this.retrieveProcedureColumnsFromMetadata(allRoutines, columnFilter);
                break;
            }
        }
    }

    private void createProcedureColumn(MetadataResultSet results, NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<ProcedureColumn> columnFilter) {
        String columnCatalogName = this.normalizeCatalogName(results.getString("PROCEDURE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("PROCEDURE_SCHEM"));
        String procedureName = results.getString("PROCEDURE_NAME");
        String columnName = results.getString("COLUMN_NAME");
        String specificName = results.getString("SPECIFIC_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving procedure column <%s.%s.%s.%s.%s>", columnCatalogName, schemaName, procedureName, specificName, columnName));
        if (Utility.isBlank(columnName)) {
            return;
        }
        Optional<MutableRoutine> optionalRoutine = allRoutines.lookup(Arrays.asList(columnCatalogName, schemaName, procedureName, specificName));
        if (!optionalRoutine.isPresent()) {
            return;
        }
        MutableRoutine routine = optionalRoutine.get();
        if (routine.getRoutineType() != RoutineType.procedure) {
            return;
        }
        MutableProcedure procedure = (MutableProcedure)routine;
        MutableProcedureColumn column = this.lookupOrCreateProcedureColumn(procedure, columnName);
        if (columnFilter.test(column) && this.belongsToSchema(procedure, columnCatalogName, schemaName)) {
            ProcedureColumnType columnType = results.getEnumFromShortId("COLUMN_TYPE", ProcedureColumnType.unknown);
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int length = results.getInt("LENGTH", 0);
            int precision = results.getInt("PRECISION", 0);
            boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
            String remarks = results.getString("REMARKS");
            column.setOrdinalPosition(ordinalPosition);
            column.setProcedureColumnType(columnType);
            column.setColumnDataType(this.lookupOrCreateColumnDataType(procedure.getSchema(), dataType, typeName));
            column.setSize(length);
            column.setPrecision(precision);
            column.setNullable(isNullable);
            column.setRemarks(remarks);
            column.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, new StringFormat("Adding column to procedure <%s>", column.getFullName()));
            procedure.addColumn(column);
        }
    }

    private MutableProcedureColumn lookupOrCreateProcedureColumn(MutableProcedure procedure, String columnName) {
        Optional<MutableProcedureColumn> columnOptional = procedure.lookupColumn(columnName);
        MutableProcedureColumn column = columnOptional.isPresent() ? columnOptional.get() : new MutableProcedureColumn(procedure, columnName);
        return column;
    }

    private void retrieveProcedureColumnsFromDataDictionary(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<ProcedureColumn> columnFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.PROCEDURE_COLUMNS)) {
            throw new SchemaCrawlerSQLException("No procedure columns SQL provided", null);
        }
        Query procedureColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.PROCEDURE_COLUMNS);
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(procedureColumnsSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveProcedureColumnsFromDataDictionary");
            while (results.next()) {
                this.createProcedureColumn(results, allRoutines, columnFilter);
            }
        }
    }

    private void retrieveProcedureColumnsFromMetadata(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<ProcedureColumn> columnFilter) throws SchemaCrawlerSQLException {
        for (MutableRoutine routine : allRoutines) {
            if (routine.getRoutineType() != RoutineType.procedure) continue;
            MutableProcedure procedure = (MutableProcedure)routine;
            LOGGER.log(Level.FINE, "Retrieving procedure columns for " + procedure);
            try {
                MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedureColumns(procedure.getSchema().getCatalogName(), procedure.getSchema().getName(), procedure.getName(), null));
                Throwable throwable = null;
                try {
                    while (results.next()) {
                        this.createProcedureColumn(results, allRoutines, columnFilter);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (SQLException e) {
                throw new SchemaCrawlerSQLException(String.format("Could not retrieve procedure columns for procedure <%s>", procedure), e);
            }
        }
    }

    private void retrieveProcedureColumnsFromMetadataForAllProcedures(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<ProcedureColumn> columnFilter) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getProcedureColumns(null, null, "%", "%"));){
            while (results.next()) {
                this.createProcedureColumn(results, allRoutines, columnFilter);
            }
        }
    }
}

