/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.filter.FilterFactory;
import schemacrawler.filter.TablesReducer;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.ReducibleCollection;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public final class ReducerFactory {
    public static Reducer<Routine> getRoutineReducer(SchemaCrawlerOptions options) {
        return new BaseReducer<Routine>(FilterFactory.routineFilter(options)){};
    }

    public static Reducer<Schema> getSchemaReducer(SchemaCrawlerOptions options) {
        return new BaseReducer<Schema>(FilterFactory.schemaFilter(options)){};
    }

    public static Reducer<Sequence> getSequenceReducer(SchemaCrawlerOptions options) {
        return new BaseReducer<Sequence>(FilterFactory.sequenceFilter(options)){};
    }

    public static Reducer<Synonym> getSynonymReducer(SchemaCrawlerOptions options) {
        return new BaseReducer<Synonym>(FilterFactory.synonymFilter(options)){};
    }

    public static Reducer<Table> getTableReducer(Predicate<Table> tableFilter) {
        return new BaseReducer<Table>(tableFilter){};
    }

    public static Reducer<Table> getTableReducer(SchemaCrawlerOptions options) {
        return new TablesReducer(options, FilterFactory.tableFilter(options));
    }

    private ReducerFactory() {
    }

    private static abstract class BaseReducer<N extends NamedObject>
    implements Reducer<N> {
        private final Predicate<N> filter;

        protected BaseReducer(Predicate<N> filter) {
            this.filter = Objects.requireNonNull(filter, "No filter provided");
        }

        @Override
        public void reduce(ReducibleCollection<? extends N> allNamedObjects) {
            Objects.requireNonNull(allNamedObjects, "No named objects provided");
            allNamedObjects.filter(this.filter);
        }
    }
}

