/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLineException;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;

public final class DatabaseServerTypeParser
extends BaseOptionsParser<DatabaseConnector> {
    private static final String URL = "url";
    private static final String SERVER = "server";

    public DatabaseServerTypeParser(Config config) {
        super(config);
    }

    @Override
    public DatabaseConnector getOptions() throws SchemaCrawlerException {
        DatabaseConnector dbConnector;
        DatabaseConnectorRegistry registry = new DatabaseConnectorRegistry();
        String databaseSystemIdentifier = this.config.getStringValue(SERVER, null);
        if (this.config.hasValue(SERVER) && !registry.hasDatabaseSystemIdentifier(databaseSystemIdentifier)) {
            throw new SchemaCrawlerCommandLineException(String.format("Unsupported server <%s> %nPlease provide a database connection URL on the command-line, %nand re-run SchemaCrawler without the -server argument", databaseSystemIdentifier));
        }
        if (databaseSystemIdentifier != null) {
            dbConnector = registry.lookupDatabaseConnector(databaseSystemIdentifier);
            this.consumeOption(SERVER);
        } else {
            String connectionUrl = this.config.getStringValue(URL, null);
            dbConnector = registry.lookupDatabaseConnectorFromUrl(connectionUrl);
        }
        return dbConnector;
    }
}

