/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

abstract class BaseCommandChain
extends BaseSchemaCrawlerCommand {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(BaseCommandChain.class.getName());
    private final List<SchemaCrawlerCommand> scCommands;
    private final CommandRegistry commandRegistry = new CommandRegistry();

    protected BaseCommandChain(String command) throws SchemaCrawlerException {
        super(command);
        this.scCommands = new ArrayList<SchemaCrawlerCommand>();
    }

    @Override
    public void checkAvailibility() throws Exception {
        this.checkAvailibilityChain();
    }

    protected final SchemaCrawlerCommand addNextAndConfigureForExecution(String command, OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            SchemaCrawlerCommand scCommand = this.commandRegistry.configureNewCommand(command, this.schemaCrawlerOptions, outputOptions);
            if (scCommand == null) {
                return null;
            }
            scCommand.setAdditionalConfiguration(this.additionalConfiguration);
            scCommand.setCatalog(this.catalog);
            scCommand.setConnection(this.connection);
            scCommand.setIdentifiers(this.identifiers);
            this.scCommands.add(scCommand);
            return scCommand;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain commands, unknown command <%s>", command));
        }
    }

    protected final void checkAvailibilityChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No commands to execute");
            return;
        }
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.checkAvailibility();
        }
    }

    protected final void executeChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No commands to execute");
            return;
        }
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.execute();
        }
    }

    protected final void initializeChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No commands to initialize");
            return;
        }
        for (SchemaCrawlerCommand scCommand : this.scCommands) {
            scCommand.initialize();
        }
    }
}

