/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.ArrayList;
import java.util.logging.Level;
import schemacrawler.utility.ProcessExecutor;
import sf.util.FileContents;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class GraphvizUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphvizUtility.class.getName());

    public static boolean isGraphvizAvailable() {
        Integer exitCode;
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.add("-V");
        LOGGER.log(Level.INFO, new StringFormat("Checking if Graphviz is available:\n%s", ((Object)command).toString()));
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.setCommandLine(command);
        try {
            exitCode = processExecutor.call();
            LOGGER.log(Level.INFO, new FileContents(processExecutor.getProcessOutput()));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not execute Graphviz command", (Throwable)e);
            LOGGER.log(Level.WARNING, new FileContents(processExecutor.getProcessError()));
            exitCode = Integer.MIN_VALUE;
        }
        boolean successful = exitCode != null && exitCode == 0;
        return successful;
    }

    private GraphvizUtility() {
    }
}

