/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import java.io.PrintWriter;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.utility.BinaryData;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.text.utility.html.Alignment;
import schemacrawler.tools.text.utility.html.Anchor;
import schemacrawler.tools.text.utility.html.TableCell;
import schemacrawler.tools.text.utility.html.TableHeaderCell;
import schemacrawler.tools.text.utility.html.TableRow;
import sf.util.Color;
import sf.util.Utility;

abstract class BaseTextFormattingHelper
implements TextFormattingHelper {
    static final String DASHED_SEPARATOR = BaseTextFormattingHelper.separator("-");
    protected final PrintWriter out;
    private final TextOutputFormat outputFormat;

    static String separator(String pattern) {
        StringBuilder dashedSeparator = new StringBuilder(72);
        for (int i = 0; i < 72 / pattern.length(); ++i) {
            dashedSeparator.append(pattern);
        }
        return dashedSeparator.toString();
    }

    public BaseTextFormattingHelper(PrintWriter out, TextOutputFormat outputFormat) {
        this.out = out;
        this.outputFormat = outputFormat;
    }

    @Override
    public TextFormattingHelper append(String text) {
        this.out.write(text);
        this.out.flush();
        return this;
    }

    @Override
    public String createAnchor(String text, String link) {
        return new Anchor(text, false, 0, Alignment.inherit, false, "", Color.white, link, this.outputFormat).toString();
    }

    @Override
    public void println() {
        this.out.println();
    }

    @Override
    public void writeDescriptionRow(String description) {
        TableRow row = new TableRow(this.outputFormat);
        row.add(this.newTableCell("", "spacer", this.outputFormat));
        row.add(new TableCell(description, true, 0, Alignment.inherit, false, "", Color.white, 2, this.outputFormat));
        this.out.println(row.toString());
    }

    @Override
    public void writeDetailRow(String text1, String text2, String text3) {
        this.writeDetailRow(text1, text2, text3, true, false, "");
    }

    @Override
    public void writeDetailRow(String text1, String text2, String text3, boolean escapeText, boolean emphasize, String style) {
        int text2Width = 32;
        int text3Width = 28;
        String text3Sytle = !Utility.isBlank(style) ? " " + style : "";
        TableRow row = new TableRow(this.outputFormat);
        if (Utility.isBlank(text1)) {
            row.add(this.newTableCell("", "spacer", this.outputFormat));
        } else {
            row.add(new TableCell(text1, true, 2, Alignment.inherit, false, "spacer", Color.white, 1, this.outputFormat));
        }
        row.add(new TableCell(text2, escapeText, 32, Alignment.inherit, emphasize, "minwidth", Color.white, 1, this.outputFormat));
        row.add(new TableCell(text3, true, 28, Alignment.inherit, false, "minwidth" + text3Sytle, Color.white, 1, this.outputFormat));
        this.out.println(row.toString());
    }

    @Override
    public void writeEmptyRow() {
        TableRow tableRow = new TableRow(this.outputFormat);
        tableRow.add(new TableCell("", true, 0, Alignment.inherit, false, "", Color.white, 3, this.outputFormat));
        this.out.println(tableRow.toString());
    }

    @Override
    public void writeNameRow(String name, String description) {
        int nameWidth = 34;
        int descriptionWidth = 36;
        if (name.length() > nameWidth && description.length() < descriptionWidth) {
            descriptionWidth = Math.max(description.length(), descriptionWidth - (name.length() - nameWidth));
        }
        if (description.length() > descriptionWidth && name.length() < nameWidth) {
            nameWidth = Math.max(name.length(), nameWidth - (description.length() - descriptionWidth));
        }
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(name, true, nameWidth, Alignment.inherit, false, "name", Color.white, 2, this.outputFormat));
        row.add(new TableCell(description, true, descriptionWidth, Alignment.right, false, "description right", Color.white, 1, this.outputFormat));
        this.out.println(row.toString());
    }

    @Override
    public void writeNameValueRow(String name, String value, Alignment valueAlignment) {
        int nameWidth = 40;
        int valueWidth = 30;
        Alignment alignmentForValue = valueAlignment == null ? Alignment.inherit : valueAlignment;
        String valueStyle = "property_value" + (alignmentForValue == Alignment.inherit ? "" : " right");
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(name, true, 40, Alignment.inherit, false, "property_name", Color.white, 1, this.outputFormat));
        row.add(new TableCell(value, true, 30, alignmentForValue, false, valueStyle, Color.white, 1, this.outputFormat));
        this.out.println(row.toString());
    }

    @Override
    public void writeRow(Object ... columnData) {
        TextOutputFormat outputFormat = this.outputFormat;
        if (outputFormat == TextOutputFormat.text) {
            outputFormat = TextOutputFormat.tsv;
        }
        TableRow row = new TableRow(outputFormat);
        for (Object element : columnData) {
            if (element == null) {
                row.add(this.newTableCell(null, "data_null", outputFormat));
                continue;
            }
            if (element instanceof BinaryData) {
                row.add(this.newTableCell(element.toString(), "data_binary", outputFormat));
                continue;
            }
            if (element instanceof Number) {
                row.add(this.newTableCell(element.toString(), "data_number", outputFormat));
                continue;
            }
            row.add(this.newTableCell(element.toString(), "", outputFormat));
        }
        this.out.println(row.toString());
    }

    @Override
    public void writeRowHeader(String ... columnNames) {
        TextOutputFormat outputFormat = this.outputFormat;
        if (outputFormat == TextOutputFormat.text) {
            outputFormat = TextOutputFormat.tsv;
        }
        TableRow row = new TableRow(outputFormat);
        for (String columnName : columnNames) {
            TableHeaderCell headerCell = new TableHeaderCell(columnName, 0, Alignment.inherit, false, "", Color.white, 1, outputFormat);
            row.add(headerCell);
        }
        this.out.println(row.toString());
    }

    @Override
    public void writeWideRow(String definition, String style) {
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(definition, true, 0, Alignment.inherit, false, style, Color.white, 3, this.outputFormat));
        this.out.println(row.toString());
    }

    private TableCell newTableCell(String text, String styleClass, TextOutputFormat outputFormat) {
        return new TableCell(text, true, 0, Alignment.inherit, false, styleClass, Color.white, 1, outputFormat);
    }
}

