/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import sf.util.SchemaCrawlerLogger;

public final class IOUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(IOUtility.class.getName());

    public static void copy(Reader reader, Writer writer) {
        if (reader == null) {
            LOGGER.log(Level.WARNING, "Cannot read null reader");
            return;
        }
        if (writer == null) {
            LOGGER.log(Level.WARNING, "Cannot write null writer");
            return;
        }
        char[] buffer = new char[65536];
        try {
            int read;
            BufferedReader bufferedReader = new BufferedReader(reader, buffer.length);
            BufferedWriter bufferedWriter = new BufferedWriter(writer, buffer.length);
            do {
                if ((read = ((Reader)bufferedReader).read(buffer, 0, buffer.length)) <= 0) continue;
                bufferedWriter.write(buffer, 0, read);
            } while (read >= 0);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), (Throwable)e);
        }
    }

    public static Path createTempFilePath(String stem, String extension) throws IOException {
        Path tempFilePath = Files.createTempFile("schemacrawler." + stem + ".", "." + extension, new FileAttribute[0]).normalize().toAbsolutePath();
        Files.delete(tempFilePath);
        tempFilePath.toFile().deleteOnExit();
        return tempFilePath;
    }

    public static String getFileExtension(Path file) {
        if (file == null) {
            return "";
        }
        String fileName = file.toString();
        return IOUtility.getFileExtension(fileName == null ? "" : fileName);
    }

    public static String getFileExtension(String fileName) {
        String ext = fileName != null ? (fileName.lastIndexOf(46) == -1 ? "" : fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length())) : "";
        return ext;
    }

    public static boolean isFileReadable(Path file) {
        if (file == null) {
            return false;
        }
        if (!Files.isReadable(file) || !Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        try {
            if (Files.size(file) == 0L) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isFileWritable(Path file) {
        if (file == null) {
            return false;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            return false;
        }
        Path parentPath = file.getParent();
        return parentPath != null && Files.exists(parentPath, new LinkOption[0]) && Files.isDirectory(parentPath, new LinkOption[0]) && Files.isWritable(parentPath);
    }

    public static String readFully(InputStream stream) {
        if (stream == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        return IOUtility.readFully(reader);
    }

    public static String readFully(Reader reader) {
        if (reader == null) {
            LOGGER.log(Level.WARNING, "Cannot read null reader");
            return "";
        }
        try {
            StringWriter writer = new StringWriter();
            IOUtility.copy(reader, writer);
            writer.close();
            return writer.toString();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String readResourceFully(String resource) {
        return IOUtility.readFully(IOUtility.class.getResourceAsStream(resource));
    }

    private IOUtility() {
    }
}

