/*
 * Decompiled with CFR 0.152.
 */
package sf.util.graph;

import java.util.HashMap;
import java.util.Map;

public final class Vertex<T> {
    private final T value;
    private final Map<String, Object> attributes;

    Vertex(T value) {
        this.value = value;
        this.attributes = new HashMap<String, Object>();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    <V> V getAttribute(String key) {
        return (V)this.attributes.get(key);
    }

    public T getValue() {
        return this.value;
    }

    boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    void putAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public String toString() {
        return this.value.toString();
    }
}

