/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.exc.WstxParsingException;
import com.ctc.wstx.exc.WstxUnexpectedCharException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;

public abstract class InputBootstrapper {
    private static final String KW_ENC = "encoding";
    private static final String KW_VERS = "version";
    private static final String KW_SA = "standalone";
    protected static final String ERR_XMLDECL_KW_VERSION = "; expected keyword 'version'";
    protected static final String ERR_XMLDECL_KW_ENCODING = "; expected keyword 'encoding'";
    protected static final String ERR_XMLDECL_KW_STANDALONE = "; expected keyword 'standalone'";
    protected static final String ERR_XMLDECL_END_MARKER = "; expected \"?>\" end marker";
    protected static final String ERR_XMLDECL_EXP_SPACE = "; expected a white space";
    protected static final String ERR_XMLDECL_EXP_EQ = "; expected '=' after ";
    protected static final String ERR_XMLDECL_EXP_ATTRVAL = "; expected a quote character enclosing value for ";
    public static final char CHAR_NULL = '\u0000';
    public static final char CHAR_SPACE = ' ';
    public static final byte CHAR_CR = 13;
    public static final byte CHAR_LF = 10;
    public static final byte BYTE_NULL = 0;
    public static final byte BYTE_CR = 13;
    public static final byte BYTE_LF = 10;
    protected final String mPublicId;
    protected final String mSystemId;
    protected int mInputProcessed = 0;
    protected int mInputRow = 1;
    protected int mInputRowStart = 0;
    boolean mHadDeclaration = false;
    String mVersion;
    String mFoundEncoding;
    String mStandalone;
    final char[] mKeyword = new char[60];

    protected InputBootstrapper(String pubId, String sysId) {
        this.mPublicId = pubId;
        this.mSystemId = sysId;
    }

    public abstract Reader bootstrapInput(boolean var1, XMLReporter var2) throws IOException, WstxException;

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getStandalone() {
        return this.mStandalone;
    }

    public String getDeclaredEncoding() {
        return this.mFoundEncoding;
    }

    public abstract int getInputTotal();

    public int getInputRow() {
        return this.mInputRow;
    }

    public abstract int getInputColumn();

    public abstract String getAppEncoding();

    protected void readXmlDecl(boolean isMainDoc) throws IOException, WstxException {
        int c = this.getNextAfterWs(false);
        if (c != 118) {
            if (isMainDoc) {
                this.reportUnexpectedChar(c, ERR_XMLDECL_KW_VERSION);
            }
        } else {
            this.mVersion = this.readXmlVersion();
            c = this.getWsOrChar(63);
        }
        if (c != 101) {
            if (!isMainDoc) {
                this.reportUnexpectedChar(c, ERR_XMLDECL_KW_ENCODING);
            }
        } else {
            this.mFoundEncoding = this.readXmlEncoding();
            c = this.getWsOrChar(63);
        }
        if (isMainDoc && c == 115) {
            this.mStandalone = this.readXmlStandalone();
            c = this.getWsOrChar(63);
        }
        if (c != 63) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_END_MARKER);
        }
        if ((c = this.getNext()) != 62) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_END_MARKER);
        }
    }

    private final String readXmlVersion() throws IOException, WstxException {
        int len;
        int c = this.checkKeyword(KW_VERS);
        if (c != 0) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_KW_VERSION);
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq(KW_VERS))) == 3 && this.mKeyword[0] == '1' && this.mKeyword[1] == '.') {
            c = this.mKeyword[2];
            if (c == 48) {
                return "1.0";
            }
            if (c == 49) {
                return "1.1";
            }
        }
        String got = len < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (len == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, len) + "'");
        throw new WstxParsingException("Invalid XML version value " + got + "; expected '1.0' or '1.1'", this.getLocation());
    }

    private final String readXmlEncoding() throws IOException, WstxException {
        int len;
        int c = this.checkKeyword(KW_ENC);
        if (c != 0) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_KW_VERSION);
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq(KW_ENC))) == 0) {
            throw new WstxParsingException("Missing XML encoding value for encoding pseudo-attribute", this.getLocation());
        }
        if (len < 0) {
            return new String(this.mKeyword);
        }
        return new String(this.mKeyword, 0, len);
    }

    private final String readXmlStandalone() throws IOException, WstxException {
        int len;
        int c = this.checkKeyword(KW_SA);
        if (c != 0) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_KW_STANDALONE);
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq(KW_SA))) == 2) {
            if (this.mKeyword[0] == 'n' && this.mKeyword[1] == 'o') {
                return "no";
            }
        } else if (len == 3 && this.mKeyword[0] == 'y' && this.mKeyword[1] == 'e' && this.mKeyword[2] == 's') {
            return "yes";
        }
        String got = len < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (len == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, len) + "'");
        throw new WstxParsingException("Invalid XML 'standalone' value " + got + "; expected 'yes' or 'no'", this.getLocation());
    }

    private final int handleEq(String attr) throws IOException, WstxException {
        int c = this.getNextAfterWs(false);
        if (c != 61) {
            this.reportUnexpectedChar(c, "; expected '=' after '" + attr + "'");
        }
        if ((c = this.getNextAfterWs(false)) != 34 && c != 39) {
            this.reportUnexpectedChar(c, "; expected a quote character enclosing value for '" + attr + "'");
        }
        return c;
    }

    private final int getWsOrChar(int ok) throws IOException, WstxException {
        int c = this.getNext();
        if (c == ok) {
            return c;
        }
        if (c > 32) {
            this.reportUnexpectedChar(c, "; expected either '" + (char)ok + "' or white space");
        }
        if (c == 10 || c == 13) {
            this.pushback();
        }
        return this.getNextAfterWs(false);
    }

    protected abstract void pushback();

    protected abstract int getNext() throws IOException, WstxException;

    protected abstract int getNextAfterWs(boolean var1) throws IOException, WstxException;

    protected abstract int checkKeyword(String var1) throws IOException, WstxException;

    protected abstract int readQuotedValue(char[] var1, int var2) throws IOException, WstxException;

    protected abstract Location getLocation();

    protected void reportNull() throws WstxException {
        Location loc = this.getLocation();
        throw new WstxException("Illegal null byte in input stream", this.getLocation());
    }

    protected void reportXmlProblem(String msg) throws WstxException {
        throw new WstxParsingException(msg, this.getLocation());
    }

    protected void reportUnexpectedChar(int i, String msg) throws WstxException {
        char c = (char)i;
        String excMsg = Character.isISOControl(c) ? "Unexpected character (CTRL-CHAR, code " + i + ")" + msg : "Unexpected character '" + c + "' (code " + i + ")" + msg;
        Location loc = this.getLocation();
        throw new WstxUnexpectedCharException(excMsg, loc, c);
    }
}

