/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import org.apache.xerces.impl.dv.DVFactoryException;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.util.SymbolHash;

public abstract class SchemaDVFactory {
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl";
    private static String fFactoryClass = null;
    private static SchemaDVFactory fFactoryInstance = null;

    public static final synchronized void setFactoryClass(String string) throws DVFactoryException {
        if (fFactoryInstance != null) {
            throw new DVFactoryException("Cannot set the class name now. The class name '" + fFactoryClass + "' is already used.");
        }
        fFactoryClass = string;
    }

    public static final synchronized SchemaDVFactory getInstance() throws DVFactoryException {
        if (fFactoryInstance != null) {
            return fFactoryInstance;
        }
        try {
            if (fFactoryClass == null) {
                fFactoryClass = DEFAULT_FACTORY_CLASS;
            }
            fFactoryInstance = (SchemaDVFactory)Class.forName(fFactoryClass).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DVFactoryException("Schema factory class " + fFactoryClass + " not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DVFactoryException("Schema factory class " + fFactoryClass + " found but cannot be loaded.");
        }
        catch (InstantiationException instantiationException) {
            throw new DVFactoryException("Schema factory class " + fFactoryClass + " loaded but cannot be instantiated (no empty public constructor?).");
        }
        catch (ClassCastException classCastException) {
            throw new DVFactoryException("Schema factory class " + fFactoryClass + " does not extend from SchemaDVFactory.");
        }
        return fFactoryInstance;
    }

    protected SchemaDVFactory() {
    }

    public abstract XSSimpleType getBuiltInType(String var1);

    public abstract SymbolHash getBuiltInTypes();

    public abstract XSSimpleType createTypeRestriction(String var1, String var2, short var3, XSSimpleType var4);

    public abstract XSSimpleType createTypeList(String var1, String var2, short var3, XSSimpleType var4);

    public abstract XSSimpleType createTypeUnion(String var1, String var2, short var3, XSSimpleType[] var4);
}

