/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer == null ? (class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer = ResolverXPointer.class$("org.apache.xml.security.utils.resolver.implementations.ResolverXPointer")) : class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer).getName());
    static /* synthetic */ Class class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        Object object2;
        NodeList nodeList = null;
        Document document = attr.getOwnerDocument();
        XMLUtils.circumventBug2650(document);
        CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
        try {
            if (ResolverXPointer.isXPointerSlash(attr, string)) {
                nodeList = cachedXPathAPI.selectNodeList((Node)document, "(//. | //@* | //namespace::*)");
            } else if (ResolverXPointer.isXPointerId(attr, string)) {
                object2 = ResolverXPointer.getXPointerId(attr, string);
                object = IdResolver.getElementById(document, (String)object2);
                if (object == null) {
                    Object[] objectArray = new Object[]{object2};
                    throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string);
                }
                nodeList = cachedXPathAPI.selectNodeList((Node)object, "(.//. | .//@* | .//namespace::*)");
            }
        }
        catch (TransformerException transformerException) {
            throw new ResourceResolverException("generic.EmptyMessage", transformerException, attr, string);
        }
        object2 = XMLUtils.convertNodelistToSet(nodeList);
        object = new XMLSignatureInput((Set)object2, cachedXPathAPI);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        try {
            URI uRI = new URI(new URI(string), attr.getNodeValue());
            ((XMLSignatureInput)object).setSourceURI(uRI.toString());
        }
        catch (URI.MalformedURIException malformedURIException) {
            ((XMLSignatureInput)object).setSourceURI(string);
        }
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            return false;
        }
        return ResolverXPointer.isXPointerSlash(attr, string) || ResolverXPointer.isXPointerId(attr, string);
    }

    private static boolean isXPointerSlash(Attr attr, String string) {
        return attr.getNodeValue().equals("#xpointer(/)");
    }

    private static boolean isXPointerId(Attr attr, String string) {
        String string2;
        String string3 = attr.getNodeValue();
        if (string3.startsWith("#xpointer(id(") && string3.endsWith("))") && ((string2 = string3.substring("#xpointer(id(".length(), string3.length() - "))".length())).charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"' || string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'')) {
            log.debug((Object)("Id=" + string2.substring(1, string2.length() - 1)));
            return true;
        }
        return false;
    }

    private static String getXPointerId(Attr attr, String string) {
        String string2;
        String string3 = attr.getNodeValue();
        if (string3.startsWith("#xpointer(id(") && string3.endsWith("))") && ((string2 = string3.substring("#xpointer(id(".length(), string3.length() - "))".length())).charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"' || string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'')) {
            return string2.substring(1, string2.length() - 1);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

